/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.content.Context;
import android.content.SharedPreferences;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.mediavrog.irr.IrrLayout;
import net.mediavrog.irr.PreferenceValue;
import net.mediavrog.ruli.Rule;
import net.mediavrog.ruli.RuleEngine;
import net.mediavrog.ruli.RuleSet;
import net.mediavrog.ruli.SimpleRule;
import net.mediavrog.ruli.Value;

public class DefaultRuleEngine
extends RuleEngine {
    public static final String TAG = DefaultRuleEngine.class.getSimpleName();
    public static final int DEFAULT_APP_START_COUNT = 10;
    public static final int DEFAULT_DISTINCT_DAYS = 3;
    public static final int DEFAULT_POSTPONE_DAYS = 6;
    public static final int DEFAULT_MAX_DISMISS_COUNT = 3;
    private static final String PREF_FILE_NAME_SUFFIX = ".irr_default_rule_engine";
    public static final String PREF_KEY_DID_RATE = "didRate";
    public static final String PREF_KEY_APP_STARTS = "appStarts";
    public static final String PREF_KEY_LAST_APP_START = "lastAppStart";
    public static final String PREF_KEY_DAYS_USED = "daysUsedApp";
    public static final String PREF_KEY_DISMISSAL_COUNT = "dismissCount";
    public static final String PREF_KEY_LAST_DISMISSED_AT = "lastDismissedAt";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static SharedPreferences sPrefs;
    private DefaultOnUserDecisionListener mListener;
    private Context mContext;

    public static DefaultRuleEngine newInstance(final Context ctx, int appStartCount, int distinctDays, final int postponeDays, int maxDismissCount) {
        PreferenceValue.PreferenceProvider pp = new PreferenceValue.PreferenceProvider(){
            SharedPreferences prefs;

            @Override
            public SharedPreferences getPreferences() {
                if (this.prefs == null) {
                    this.prefs = DefaultRuleEngine.getPreferences(ctx);
                }
                return this.prefs;
            }
        };
        RuleSet rule = new RuleSet.Builder().addRule((Rule)new SimpleRule(PreferenceValue.b(pp, PREF_KEY_DID_RATE), SimpleRule.Comparator.EQ, (Comparable)Boolean.valueOf(false))).addRule((Rule)new SimpleRule(PreferenceValue.i(pp, PREF_KEY_APP_STARTS), SimpleRule.Comparator.GT_EQ, (Comparable)Integer.valueOf(appStartCount))).addRule((Rule)new SimpleRule(PreferenceValue.i(pp, PREF_KEY_DAYS_USED), SimpleRule.Comparator.GT_EQ, (Comparable)Integer.valueOf(distinctDays))).addRule((Rule)new SimpleRule(PreferenceValue.i(pp, PREF_KEY_DISMISSAL_COUNT), SimpleRule.Comparator.LT, (Comparable)Integer.valueOf(maxDismissCount))).addRule((Rule)new SimpleRule(PreferenceValue.s(pp, PREF_KEY_LAST_DISMISSED_AT), SimpleRule.Comparator.LT_EQ, (Value)new Value<String>(){

            public String get() {
                Calendar c = Calendar.getInstance();
                c.add(5, -1 * postponeDays);
                return new SimpleDateFormat(DefaultRuleEngine.DEFAULT_DATE_FORMAT, Locale.getDefault()).format(c.getTime());
            }
        })).build();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add((Rule)rule);
        return new DefaultRuleEngine(ctx, rules);
    }

    public DefaultRuleEngine(Context ctx, List<Rule> rules) {
        super(rules);
        this.mContext = ctx;
    }

    public void setListener(DefaultOnUserDecisionListener l) {
        this.mListener = l;
    }

    public DefaultOnUserDecisionListener getListener() {
        if (this.mListener == null) {
            this.mListener = new DefaultOnUserDecisionListener();
        }
        return this.mListener;
    }

    public String toString(boolean evaluate) {
        StringBuilder s = new StringBuilder();
        s.append("DefaultRuleEngine").append("\n");
        s.append(super.toString(evaluate));
        return s.toString();
    }

    public void reset() {
        DefaultRuleEngine.reset(this.mContext);
    }

    public static void reset(Context ctx) {
        DefaultRuleEngine.getPreferences(ctx).edit().clear().apply();
    }

    public void trackAppStart() {
        DefaultRuleEngine.trackAppStart(this.mContext);
    }

    public static void trackAppStart(Context ctx) {
        SharedPreferences s = DefaultRuleEngine.getPreferences(ctx);
        int appStarts = s.getInt(PREF_KEY_APP_STARTS, 0) + 1;
        int daysUsed = s.getInt(PREF_KEY_DAYS_USED, 1);
        String today = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.getDefault()).format(new Date());
        String lastAppStart = s.getString(PREF_KEY_LAST_APP_START, today);
        if (!lastAppStart.equals(today)) {
            ++daysUsed;
        }
        s.edit().putInt(PREF_KEY_APP_STARTS, appStarts).putString(PREF_KEY_LAST_APP_START, today).putInt(PREF_KEY_DAYS_USED, daysUsed).apply();
    }

    public void trackDismissal() {
        DefaultRuleEngine.trackDismissal(this.mContext);
    }

    public static void trackDismissal(Context ctx) {
        SharedPreferences s = DefaultRuleEngine.getPreferences(ctx);
        int dismissalCount = s.getInt(PREF_KEY_DISMISSAL_COUNT, 0) + 1;
        String today = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.getDefault()).format(new Date());
        s.edit().putInt(PREF_KEY_DISMISSAL_COUNT, dismissalCount).putString(PREF_KEY_LAST_DISMISSED_AT, today).apply();
    }

    public void trackRated() {
        DefaultRuleEngine.trackRated(this.mContext);
    }

    public static void trackRated(Context ctx) {
        SharedPreferences s = DefaultRuleEngine.getPreferences(ctx);
        s.edit().putBoolean(PREF_KEY_DID_RATE, true).apply();
    }

    public void trackFeedback() {
        DefaultRuleEngine.trackFeedback(this.mContext);
    }

    public static void trackFeedback(Context ctx) {
        DefaultRuleEngine.trackDismissal(ctx);
    }

    public static SharedPreferences getPreferences(Context ctx) {
        if (sPrefs == null) {
            sPrefs = ctx.getSharedPreferences(DefaultRuleEngine.getPrefFileName(ctx), 0);
        }
        return sPrefs;
    }

    public static String getPrefFileName(Context ctx) {
        return ctx.getPackageName() + PREF_FILE_NAME_SUFFIX;
    }

    public static class DefaultOnUserDecisionListener
    implements IrrLayout.OnUserDecisionListener {
        @Override
        public void onAccept(Context ctx, IrrLayout.State s) {
            switch (s) {
                case RATE: {
                    DefaultRuleEngine.trackRated(ctx);
                    break;
                }
                case FEEDBACK: {
                    DefaultRuleEngine.trackFeedback(ctx);
                }
            }
        }

        @Override
        public void onDismiss(Context ctx, IrrLayout.State s) {
            switch (s) {
                case RATE: 
                case FEEDBACK: {
                    DefaultRuleEngine.trackDismissal(ctx);
                }
            }
        }
    }
}

