/*
 * Decompiled with CFR 0.152.
 */
package net.mediavrog.irr;

import android.content.Context;
import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import net.mediavrog.irr.IrrLayout;
import net.mediavrog.ruli.RuleEngine;

public class IrrAdapterDecorator
extends BaseAdapter {
    public static final String TAG = IrrAdapterDecorator.class.getSimpleName();
    private static final int IRR_ITEM_TYPE = 0;
    @NonNull
    private final BaseAdapter mDecoratedBaseAdapter;
    private int mIrrElementPosition;
    @NonNull
    private IrrLayout mIrrLayout;
    private boolean mIsShown;

    public IrrAdapterDecorator(Context ctx, @NonNull BaseAdapter baseAdapter, int irrPosition, int irrLayoutId) {
        this(ctx, baseAdapter, irrPosition, irrLayoutId, null);
    }

    public IrrAdapterDecorator(Context ctx, @NonNull BaseAdapter baseAdapter, int irrPosition, int irrLayoutId, @Nullable RuleEngine engine) {
        this(baseAdapter, irrPosition, (IrrLayout)LayoutInflater.from((Context)ctx).inflate(irrLayoutId, null, false), engine);
    }

    public IrrAdapterDecorator(@NonNull BaseAdapter baseAdapter, int irrPosition, @NonNull IrrLayout irrLayout, @Nullable RuleEngine engine) {
        this.mDecoratedBaseAdapter = baseAdapter;
        this.mIrrElementPosition = irrPosition;
        this.mIrrLayout = irrLayout;
        this.mIrrLayout.setOnToggleVisibilityListener(new IrrLayout.OnToggleVisibilityListener(){

            @Override
            public void onShow(IrrLayout irr) {
                IrrAdapterDecorator.this.mIsShown = true;
                IrrAdapterDecorator.this.notifyDataSetChanged(true);
            }

            @Override
            public void onHide(IrrLayout irr) {
                IrrAdapterDecorator.this.mIsShown = false;
                IrrAdapterDecorator.this.notifyDataSetChanged(true);
            }
        });
        if (engine != null) {
            this.mIrrLayout.setRuleEngine(engine);
        }
        this.notifyRuleEngineStateChanged();
    }

    @NonNull
    public BaseAdapter getDecoratedBaseAdapter() {
        return this.mDecoratedBaseAdapter;
    }

    @NonNull
    protected BaseAdapter getRootAdapter() {
        BaseAdapter adapter = this.mDecoratedBaseAdapter;
        while (adapter instanceof IrrAdapterDecorator) {
            adapter = ((IrrAdapterDecorator)adapter).getDecoratedBaseAdapter();
        }
        return adapter;
    }

    public int getCount() {
        return this.mDecoratedBaseAdapter.getCount() + this.getOffset();
    }

    public Object getItem(int position) {
        return this.mDecoratedBaseAdapter.getItem(this.getRealPosition(position));
    }

    public long getItemId(int position) {
        return this.mDecoratedBaseAdapter.getItemId(this.getRealPosition(position));
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (this.mIsShown && this.getItemViewType(position) == 0) {
            if (convertView instanceof IrrLayout) {
                return convertView;
            }
            return this.mIrrLayout;
        }
        return this.mDecoratedBaseAdapter.getView(this.getRealPosition(position), convertView, parent);
    }

    public boolean areAllItemsEnabled() {
        return this.mDecoratedBaseAdapter.areAllItemsEnabled();
    }

    @NonNull
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return this.mDecoratedBaseAdapter.getDropDownView(this.getRealPosition(position), convertView, parent);
    }

    public int getItemViewType(int position) {
        if (this.mIsShown && position == this.mIrrElementPosition) {
            return 0;
        }
        return this.mDecoratedBaseAdapter.getItemViewType(this.getRealPosition(position)) + 1;
    }

    public int getViewTypeCount() {
        return this.mDecoratedBaseAdapter.getViewTypeCount() + 1;
    }

    public boolean hasStableIds() {
        return this.mDecoratedBaseAdapter.hasStableIds();
    }

    public boolean isEmpty() {
        return this.mDecoratedBaseAdapter.isEmpty();
    }

    public boolean isEnabled(int position) {
        return this.mDecoratedBaseAdapter.isEnabled(this.getRealPosition(position));
    }

    public void notifyDataSetChanged() {
        if (!(this.mDecoratedBaseAdapter instanceof ArrayAdapter)) {
            this.mDecoratedBaseAdapter.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged(boolean force) {
        if (force || !(this.mDecoratedBaseAdapter instanceof ArrayAdapter)) {
            this.mDecoratedBaseAdapter.notifyDataSetChanged();
        }
    }

    public void notifyDataSetInvalidated() {
        this.mDecoratedBaseAdapter.notifyDataSetInvalidated();
    }

    public void registerDataSetObserver(@NonNull DataSetObserver observer) {
        this.mDecoratedBaseAdapter.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(@NonNull DataSetObserver observer) {
        this.mDecoratedBaseAdapter.unregisterDataSetObserver(observer);
    }

    public RuleEngine getUnderlyingRuleEngine() {
        return this.mIrrLayout.getRuleEngine();
    }

    public void notifyRuleEngineStateChanged() {
        this.mIsShown = this.mIrrLayout.getRuleEngine().evaluate();
        this.notifyDataSetChanged(true);
    }

    private int getRealPosition(int position) {
        return position > this.mIrrElementPosition ? position - this.getOffset() : position;
    }

    private int getOffset() {
        return this.mIsShown ? 1 : 0;
    }
}

