/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;
import org.codehaus.plexus.util.Base64;

public class EmbeddingDeserializer
extends CucumberJsonDeserializer<Embedding> {
    @Override
    public Embedding deserialize(JsonNode rootNode, Configuration configuration) {
        String data = rootNode.get("data").asText();
        String mimeType = this.findMimeType(rootNode);
        Embedding embedding = new Embedding(mimeType, data);
        this.storeEmbedding(embedding, configuration.getEmbeddingDirectory());
        return embedding;
    }

    private String findMimeType(JsonNode rootNode) {
        JsonNode media = rootNode.get("media");
        if (media != null) {
            return media.get("type").asText();
        }
        return rootNode.get("mime_type").asText();
    }

    private void storeEmbedding(Embedding embedding, File embeddingDirectory) {
        Path file = FileSystems.getDefault().getPath(embeddingDirectory.getAbsolutePath(), embedding.getFileId() + "." + embedding.getExtension());
        byte[] decodedData = Base64.decodeBase64((byte[])embedding.getData().getBytes(StandardCharsets.UTF_8));
        try {
            Files.write(file, decodedData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }
}

