/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.EmptyReportable;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.Trends;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FailuresOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.FeaturesOverviewPage;
import net.masterthought.cucumber.generators.StepsOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.generators.TagsOverviewPage;
import net.masterthought.cucumber.generators.TrendsOverviewPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportBuilder {
    private static final Logger LOG = LogManager.getLogger(ReportBuilder.class);
    public static final String HOME_PAGE = "overview-features.html";
    public static final String BASE_DIRECTORY = "cucumber-html-reports";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ReportResult reportResult;
    private final ReportParser reportParser;
    private Configuration configuration;
    private List<String> jsonFiles;
    private boolean wasTrendsFileSaved = false;

    public ReportBuilder(List<String> jsonFiles, Configuration configuration) {
        this.jsonFiles = jsonFiles;
        this.configuration = configuration;
        this.reportParser = new ReportParser(configuration);
    }

    public Reportable generateReports() {
        Trends trends = null;
        try {
            this.copyStaticResources();
            this.createEmbeddingsDirectory();
            this.reportParser.parseClassificationsFiles(this.configuration.getClassificationFiles());
            List<Feature> features = this.reportParser.parseJsonFiles(this.jsonFiles);
            this.reportResult = new ReportResult(features, this.configuration.getSortingMethod());
            Reportable reportable = this.reportResult.getFeatureReport();
            if (this.configuration.isTrendsStatsFile()) {
                trends = this.updateAndSaveTrends(reportable);
            }
            this.generatePages(trends);
            return reportable;
        }
        catch (Exception e) {
            this.generateErrorPage(e);
            if (!this.wasTrendsFileSaved && this.configuration.isTrendsStatsFile()) {
                EmptyReportable reportable = new EmptyReportable();
                this.updateAndSaveTrends(reportable);
            }
            return null;
        }
    }

    private void copyStaticResources() {
        this.copyResources("css", "cucumber.css", "bootstrap.min.css", "font-awesome.min.css");
        this.copyResources("js", "jquery.min.js", "jquery.tablesorter.min.js", "bootstrap.min.js", "Chart.min.js", "moment.min.js");
        this.copyResources("fonts", "FontAwesome.otf", "fontawesome-webfont.svg", "fontawesome-webfont.woff", "fontawesome-webfont.eot", "fontawesome-webfont.ttf", "fontawesome-webfont.woff2", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.woff2", "glyphicons-halflings-regular.woff", "glyphicons-halflings-regular.ttf", "glyphicons-halflings-regular.svg");
        this.copyResources("images", "favicon.png");
    }

    private void createEmbeddingsDirectory() {
        this.configuration.getEmbeddingDirectory().mkdirs();
    }

    private void copyResources(String resourceLocation, String ... resources) {
        for (String resource : resources) {
            File tempFile = new File(this.configuration.getReportDirectory().getAbsoluteFile(), BASE_DIRECTORY + File.separatorChar + resourceLocation + File.separatorChar + resource);
            try {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resource), (File)tempFile);
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
    }

    private void generatePages(Trends trends) {
        new FeaturesOverviewPage(this.reportResult, this.configuration).generatePage();
        for (Feature feature : this.reportResult.getAllFeatures()) {
            new FeatureReportPage(this.reportResult, this.configuration, feature).generatePage();
        }
        new TagsOverviewPage(this.reportResult, this.configuration).generatePage();
        for (TagObject tagObject : this.reportResult.getAllTags()) {
            new TagReportPage(this.reportResult, this.configuration, tagObject).generatePage();
        }
        new StepsOverviewPage(this.reportResult, this.configuration).generatePage();
        new FailuresOverviewPage(this.reportResult, this.configuration).generatePage();
        if (this.configuration.isTrendsStatsFile()) {
            new TrendsOverviewPage(this.reportResult, this.configuration, trends).generatePage();
        }
    }

    private Trends updateAndSaveTrends(Reportable reportable) {
        Trends trends = this.loadOrCreateTrends();
        this.appendToTrends(trends, reportable);
        this.saveTrends(trends, this.configuration.getTrendsStatsFile());
        if (this.configuration.getTrendsLimit() > 0) {
            trends.limitItems(this.configuration.getTrendsLimit());
        }
        return trends;
    }

    private Trends loadOrCreateTrends() {
        File trendsFile = this.configuration.getTrendsStatsFile();
        if (trendsFile != null && trendsFile.exists()) {
            return ReportBuilder.loadTrends(trendsFile);
        }
        return new Trends();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Trends loadTrends(File file) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            Trends trends = (Trends)mapper.readValue((Reader)reader, Trends.class);
            return trends;
        }
        catch (JsonMappingException e) {
            throw new ValidationException(String.format("File '%s' could not be parsed as file with trends!", file), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private void appendToTrends(Trends trends, Reportable result) {
        trends.addBuild(this.configuration.getBuildNumber(), result);
    }

    private void saveTrends(Trends trends, File file) {
        ObjectWriter objectWriter = mapper.writer().with(SerializationFeature.INDENT_OUTPUT);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            objectWriter.writeValue((Writer)writer, (Object)trends);
            this.wasTrendsFileSaved = true;
        }
        catch (IOException e) {
            this.wasTrendsFileSaved = false;
            throw new ValidationException("Could not save updated trends in file: " + file.getAbsolutePath(), e);
        }
    }

    private void generateErrorPage(Exception exception) {
        LOG.info((Object)exception);
        ErrorPage errorPage = new ErrorPage(this.reportResult, this.configuration, exception, this.jsonFiles);
        errorPage.generatePage();
    }
}

