/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.Trends;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FailuresOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.FeaturesOverviewPage;
import net.masterthought.cucumber.generators.StepsOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.generators.TagsOverviewPage;
import net.masterthought.cucumber.generators.TrendsOverviewPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportBuilder {
    private static final Logger LOG = LogManager.getLogger(ReportBuilder.class);
    public static final String HOME_PAGE = "overview-features.html";
    public static final String BASE_DIRECTORY = "cucumber-html-reports";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ReportResult reportResult;
    private final ReportParser reportParser;
    private Configuration configuration;
    private List<String> jsonFiles;

    public ReportBuilder(List<String> jsonFiles, Configuration configuration) {
        this.jsonFiles = jsonFiles;
        this.configuration = configuration;
        this.reportParser = new ReportParser(configuration);
    }

    public Reportable generateReports() {
        try {
            this.copyStaticResources();
            this.createEmbeddingsDirectory();
            List<Feature> features = this.reportParser.parseJsonFiles(this.jsonFiles);
            this.reportResult = new ReportResult(features);
            List<AbstractPage> pages = this.collectPages();
            this.generatePages(pages);
            return this.reportResult.getFeatureReport();
        }
        catch (Exception e) {
            this.generateErrorPage(e);
            return null;
        }
    }

    private void copyStaticResources() {
        this.copyResources("css", "cucumber.css", "bootstrap.min.css", "font-awesome.min.css");
        this.copyResources("js", "jquery.min.js", "jquery.tablesorter.min.js", "bootstrap.min.js", "Chart.min.js");
        this.copyResources("fonts", "FontAwesome.otf", "fontawesome-webfont.svg", "fontawesome-webfont.woff", "fontawesome-webfont.eot", "fontawesome-webfont.ttf", "fontawesome-webfont.woff2", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.woff2", "glyphicons-halflings-regular.woff", "glyphicons-halflings-regular.ttf", "glyphicons-halflings-regular.svg");
        this.copyResources("images", "favicon.png");
    }

    private void createEmbeddingsDirectory() {
        this.configuration.getEmbeddingDirectory().mkdirs();
    }

    private void copyResources(String resourceLocation, String ... resources) {
        for (String resource : resources) {
            File tempFile = new File(this.configuration.getReportDirectory().getAbsoluteFile(), BASE_DIRECTORY + File.separatorChar + resourceLocation + File.separatorChar + resource);
            try {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resource), (File)tempFile);
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
    }

    private List<AbstractPage> collectPages() {
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        pages.add(new FeaturesOverviewPage(this.reportResult, this.configuration));
        for (Feature feature : this.reportResult.getAllFeatures()) {
            pages.add(new FeatureReportPage(this.reportResult, this.configuration, feature));
        }
        pages.add(new TagsOverviewPage(this.reportResult, this.configuration));
        for (TagObject tagObject : this.reportResult.getAllTags()) {
            pages.add(new TagReportPage(this.reportResult, this.configuration, tagObject));
        }
        pages.add(new StepsOverviewPage(this.reportResult, this.configuration));
        pages.add(new FailuresOverviewPage(this.reportResult, this.configuration));
        if (this.configuration.getTrendsStatsFile() != null) {
            Trends trends = this.updateAndGenerateTrends(this.configuration.getTrendsStatsFile());
            pages.add(new TrendsOverviewPage(this.reportResult, this.configuration, trends));
        }
        return pages;
    }

    private void generatePages(List<AbstractPage> pages) {
        for (AbstractPage page : pages) {
            page.generatePage();
        }
    }

    private Trends updateAndGenerateTrends(File trendsFile) {
        Trends trends = ReportBuilder.loadTrends(trendsFile);
        this.appendCurrentReport(trends);
        ReportBuilder.applyPatchForFeatures(trends);
        this.saveTrends(trends, trendsFile);
        return trends;
    }

    private void appendCurrentReport(Trends trends) {
        Reportable result = this.reportResult.getFeatureReport();
        trends.addBuild(this.configuration.getBuildNumber(), result.getFailedFeatures(), result.getFeatures(), result.getFailedScenarios(), result.getScenarios(), result.getFailedSteps(), result.getSteps());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Trends loadTrends(File file) {
        if (!file.exists()) {
            return new Trends();
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            Trends trends = (Trends)mapper.readValue((Reader)reader, Trends.class);
            return trends;
        }
        catch (JsonMappingException e) {
            throw new ValidationException(String.format("File '%s' could not be parsed as file with trends!", file), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private void saveTrends(Trends trends, File file) {
        ObjectWriter objectWriter = mapper.writer().with(SerializationFeature.INDENT_OUTPUT);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            objectWriter.writeValue((Writer)writer, (Object)trends);
        }
        catch (IOException e) {
            throw new ValidationException("Could not save updated trends in file: " + file.getAbsolutePath(), e);
        }
    }

    private void generateErrorPage(Exception exception) {
        LOG.info((Object)exception);
        ErrorPage errorPage = new ErrorPage(this.reportResult, this.configuration, exception, this.jsonFiles);
        errorPage.generatePage();
    }

    private static void applyPatchForFeatures(Trends trends) {
        for (int i = 0; i < trends.getTotalFeatures().length; ++i) {
            int failures;
            int total = trends.getTotalFeatures()[i];
            if (total >= (failures = trends.getFailedFeatures()[i])) continue;
            int tmp = total;
            trends.getTotalFeatures()[i] = failures;
            trends.getFailedFeatures()[i] = tmp;
            LOG.debug("Value of total feature was smaller than for failed feature - fixed");
        }
    }
}

