/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;

public class TagObject {
    private final String tagName;
    private final List<Scenario> scenarios = new ArrayList<Scenario>();
    private final String reportFileName;
    private int scenarioCounter;
    private StatusCounter scenariosStatusCounter = new StatusCounter();
    private StatusCounter stepsStatusCounter = new StatusCounter();
    private long totalDuration;
    private int totalSteps;
    private Status status = Status.PASSED;

    public TagObject(String tagName) {
        this.tagName = tagName;
        this.reportFileName = tagName.replace("@", "").replaceAll(":", "-").trim() + ".html";
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public void addScenarios(Scenario scenario) {
        this.scenarios.add(scenario);
        if (this.status != Status.FAILED && scenario.getStatus() != Status.PASSED) {
            this.status = Status.FAILED;
        }
        ++this.scenarioCounter;
        this.scenariosStatusCounter.incrementFor(scenario.getStatus());
        for (Step step : scenario.getSteps()) {
            this.stepsStatusCounter.incrementFor(step.getStatus());
            this.totalDuration += step.getDuration();
            ++this.totalSteps;
        }
    }

    public int getNumberOfScenarios() {
        return this.scenarioCounter;
    }

    public Integer getNumberOfPassingScenarios() {
        return this.scenariosStatusCounter.getValueFor(Status.PASSED);
    }

    public Integer getNumberOfFailingScenarios() {
        return this.scenariosStatusCounter.getValueFor(Status.FAILED);
    }

    public String getTotalDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public int getNumberOfSteps() {
        return this.totalSteps;
    }

    public int getNumberOfStatus(Status status) {
        return this.stepsStatusCounter.getValueFor(status);
    }

    public int getNumberOfPasses() {
        return this.getNumberOfStatus(Status.PASSED);
    }

    public int getNumberOfFailures() {
        return this.getNumberOfStatus(Status.FAILED);
    }

    public int getNumberOfSkipped() {
        return this.getNumberOfStatus(Status.SKIPPED);
    }

    public int getNumberOfUndefined() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    public int getNumberOfMissing() {
        return this.getNumberOfStatus(Status.MISSING);
    }

    public int getNumberOfPending() {
        return this.getNumberOfStatus(Status.UNDEFINED);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getRawStatus() {
        return this.status.name().toLowerCase();
    }
}

