/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Embedded;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Step
implements ResultsWithMatch {
    private String name = null;
    private final String keyword;
    private final String line;
    private final Result result = null;
    private final Row[] rows = new Row[0];
    private final Match match = null;
    private final Embedded[] embeddings = new Embedded[0];
    private final JsonElement[] output = new JsonElement[0];
    private final DocString doc_string = null;
    private static int labelCount = 0;
    private String attachments;
    private String[] outputs;
    private Status status;

    public Step() {
        this.keyword = null;
        this.line = null;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String[] getOutput() {
        return this.outputs;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public Object[] getEmbeddings() {
        return this.embeddings;
    }

    public boolean hasRows() {
        return ArrayUtils.isNotEmpty((Object[])this.rows);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.result == null ? 0L : this.result.getDuration();
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        Status status = this.getStatus();
        String errorMessage = null;
        switch (status) {
            case FAILED: {
                errorMessage = this.result.getErrorMessage();
                return this.getStatusDetails(status, errorMessage);
            }
            case MISSING: {
                errorMessage = "<span class=\"missing\">Result was missing for this step</span>";
                return this.getStatusDetails(status, errorMessage);
            }
        }
        return this.getStatusDetails(status, errorMessage);
    }

    private String getStatusDetails(Status status, String errorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"").append(status.getName().toLowerCase()).append("\">");
        sb.append("<span class=\"step-keyword\">").append(this.keyword).append(" </span>");
        sb.append("<span class=\"step-name\">").append(StringEscapeUtils.escapeHtml((String)this.name)).append("</span>");
        sb.append("<span class=\"step-duration\">");
        if (status != Status.MISSING) {
            sb.append(Util.formatDuration(this.result.getDuration()));
        }
        sb.append("</span>");
        if (status == Status.FAILED || status == Status.MISSING) {
            sb.append("<div class=\"step-error-message\"><pre class=\"step-error-message-content\">").append(this.convertEOL(errorMessage)).append("</pre></div>");
        }
        sb.append("</div>");
        sb.append(this.getAttachments());
        return sb.toString();
    }

    public String getDocString() {
        if (this.doc_string == null || !this.doc_string.hasValue()) {
            return "";
        }
        return "<div class=\"" + this.getStatus().getName().toLowerCase() + "\">" + "<div class=\"doc-string\">" + this.doc_string.getEscapedValue() + "</div></div>";
    }

    private String convertEOL(String errorMessage) {
        if (StringUtils.isEmpty((String)errorMessage)) {
            return "";
        }
        return errorMessage.replaceAll("\\\\n", "<br/>");
    }

    public String getAttachments() {
        return this.attachments;
    }

    public void setMedaData(Scenario scenario) {
        this.calculateAttachments();
        this.calculateOutputs();
        this.calculateStatus();
    }

    private void calculateAttachments() {
        StringBuilder sb = new StringBuilder();
        if (this.embeddings != null) {
            for (int i = 0; i < this.embeddings.length; ++i) {
                sb.append(this.embeddings[i].render(i));
            }
        }
        this.attachments = sb.toString();
    }

    private void calculateOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : this.output) {
            String elementString;
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                elementString = element.getAsString();
                list.add(StringEscapeUtils.escapeHtml((String)elementString));
                continue;
            }
            elementString = element.toString();
            list.add(StringEscapeUtils.escapeHtml((String)elementString));
        }
        this.outputs = list.toArray(new String[list.size()]);
    }

    private void calculateStatus() {
        this.status = this.result == null ? Status.MISSING : Status.valueOf(this.result.getStatus().toUpperCase());
    }
}

