/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Hook;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Scenario {
    private final String id;
    private final String name;
    private final String type;
    private final String description;
    private final String keyword;
    private final Step[] steps = new Step[0];
    private final Hook[] before = new Hook[0];
    private final Hook[] after = new Hook[0];
    private final Tag[] tags = new Tag[0];
    private StatusCounter statusCounter;
    private Feature feature;

    public Scenario() {
        this.id = null;
        this.name = null;
        this.type = null;
        this.description = null;
        this.keyword = null;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public Hook[] getBefore() {
        return this.before;
    }

    public Hook[] getAfter() {
        return this.after;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public Status getStatus() {
        if (this.statusCounter.getValueFor(Status.FAILED) > 0) {
            return Status.FAILED;
        }
        ConfigurationOptions configuration = ConfigurationOptions.instance();
        if (configuration.skippedFailsBuild() && this.statusCounter.getValueFor(Status.SKIPPED) > 0) {
            return Status.FAILED;
        }
        if (configuration.pendingFailsBuild() && this.statusCounter.getValueFor(Status.PENDING) > 0) {
            return Status.FAILED;
        }
        if (configuration.undefinedFailsBuild() && this.statusCounter.getValueFor(Status.UNDEFINED) > 0) {
            return Status.FAILED;
        }
        if (configuration.missingFailsBuild() && this.statusCounter.getValueFor(Status.MISSING) > 0) {
            return Status.FAILED;
        }
        return Status.PASSED;
    }

    public String getId() {
        return this.id;
    }

    public String getRawName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"").append(this.getStatus().getName().toLowerCase()).append("\">");
        if (StringUtils.isNotEmpty((String)this.keyword)) {
            sb.append("<span class=\"scenario-keyword\">").append(StringEscapeUtils.escapeHtml((String)this.keyword)).append(": </span>");
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            sb.append("<span class=\"scenario-name\">").append(StringEscapeUtils.escapeHtml((String)this.name)).append("</span>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    public boolean hasTags() {
        return this.tags.length > 0;
    }

    public boolean hasSteps() {
        return this.steps.length > 0;
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scenario other = (Scenario)obj;
        return this.id != null ? this.id.equals(other.id) : super.equals(obj);
    }

    public void setMedaData(Feature feature) {
        this.feature = feature;
        for (Step step : this.steps) {
            step.setMedaData(this);
        }
        this.calculateStatus();
    }

    private void calculateStatus() {
        this.statusCounter = new StatusCounter();
        for (Step step : this.steps) {
            this.statusCounter.incrementFor(step.getStatus());
        }
    }
}

