/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.charts.FlashChartBuilder;
import net.masterthought.cucumber.charts.JsChartUtil;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;

public class TagOverviewPage
extends AbstractPage {
    public TagOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "tagOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        List<TagObject> tags = this.reportInformation.getTags();
        this.contextMap.put("all_tags", (Object)tags);
        this.contextMap.put("total_scenarios", (Object)this.reportInformation.getTotalTagScenarios());
        this.contextMap.put("total_passed_scenarios", (Object)this.reportInformation.getTotalTagScenariosPassed());
        this.contextMap.put("total_failed_scenarios", (Object)this.reportInformation.getTotalTagScenariosFailed());
        this.contextMap.put("total_steps", (Object)this.reportInformation.getTotalTagSteps());
        this.contextMap.put("total_passes", (Object)this.reportInformation.getTotalTagPasses());
        this.contextMap.put("total_fails", (Object)this.reportInformation.getTotalTagFails());
        this.contextMap.put("total_skipped", (Object)this.reportInformation.getTotalTagSkipped());
        this.contextMap.put("total_pending", (Object)this.reportInformation.getTotalTagPending());
        this.contextMap.put("total_undefined", (Object)this.reportInformation.getTotalTagUndefined());
        this.contextMap.put("total_missing", (Object)this.reportInformation.getTotalTagMissing());
        boolean flashCharts = this.reportBuilder.isFlashCharts();
        boolean highCharts = this.reportBuilder.isHighCharts();
        if (flashCharts) {
            this.contextMap.put("chart_data", (Object)FlashChartBuilder.generateStackedColumnChart(tags));
        } else if (highCharts) {
            this.contextMap.put("chart_categories", (Object)JsChartUtil.getTags(tags));
            this.contextMap.put("chart_data", (Object)JsChartUtil.generateTagChartDataForHighCharts(tags));
        } else {
            this.contextMap.put("chart_rows", (Object)JsChartUtil.generateTagChartData(tags));
        }
        this.contextMap.put("total_duration", (Object)Util.formatDuration(this.reportInformation.getTotalTagDuration()));
        this.contextMap.put("flash_charts", (Object)flashCharts);
        this.contextMap.put("high_charts", (Object)highCharts);
        this.contextMap.put("total_duration", (Object)Util.formatDuration(this.reportInformation.getTotalTagDuration()));
        super.generateReport("tag-overview.html");
    }
}

