/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;

public class ReportInformation {
    private final List<Feature> features;
    private long totalDuration;
    private long totalTagDuration;
    private int totalTagSteps;
    private final Map<String, TagObject> allTags = new TreeMap<String, TagObject>();
    private final Map<String, StepObject> allSteps = new HashMap<String, StepObject>();
    private final StatusCounter tagStatusCounter = new StatusCounter();
    private final StatusCounter tagCounter = new StatusCounter();
    private final StatusCounter scenarioCounter = new StatusCounter();
    private final StatusCounter stepStatusCounter = new StatusCounter();

    public ReportInformation(List<Feature> features) {
        this.features = features;
        this.processFeatures();
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<TagObject> getTags() {
        return new ArrayList<TagObject>(this.allTags.values());
    }

    public Map<String, StepObject> getAllSteps() {
        return this.allSteps;
    }

    public int getTotalScenarios() {
        return this.scenarioCounter.size();
    }

    public StatusCounter getStepsCounter() {
        return this.stepStatusCounter;
    }

    public int getTotalStepsPassed() {
        return this.stepStatusCounter.getValueFor(Status.PASSED);
    }

    public int getTotalStepsFailed() {
        return this.stepStatusCounter.getValueFor(Status.FAILED);
    }

    public int getTotalStepsSkipped() {
        return this.stepStatusCounter.getValueFor(Status.SKIPPED);
    }

    public int getTotalStepsPending() {
        return this.stepStatusCounter.getValueFor(Status.PENDING);
    }

    public int getTotalStepsMissing() {
        return this.stepStatusCounter.getValueFor(Status.MISSING);
    }

    public int getTotalStepsUndefined() {
        return this.stepStatusCounter.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDurationAsString() {
        return Util.formatDuration(this.totalDuration);
    }

    public Long getTotalDuration() {
        return this.totalDuration;
    }

    public String timeStamp() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(new Date());
    }

    public int getTotalTagScenarios() {
        return this.tagCounter.size();
    }

    public int getTotalTagScenariosPassed() {
        return this.tagCounter.getValueFor(Status.PASSED);
    }

    public int getTotalTagScenariosFailed() {
        return this.tagCounter.getValueFor(Status.FAILED);
    }

    public int getTotalTagSteps() {
        return this.totalTagSteps;
    }

    public int getTotalTagPasses() {
        return this.tagStatusCounter.getValueFor(Status.PASSED);
    }

    public int getTotalTagFails() {
        return this.tagStatusCounter.getValueFor(Status.FAILED);
    }

    public int getTotalTagSkipped() {
        return this.tagStatusCounter.getValueFor(Status.SKIPPED);
    }

    public int getTotalTagPending() {
        return this.tagStatusCounter.getValueFor(Status.PENDING);
    }

    public int getTotalTagUndefined() {
        return this.tagStatusCounter.getValueFor(Status.UNDEFINED);
    }

    public int getTotalTagMissing() {
        return this.tagStatusCounter.getValueFor(Status.MISSING);
    }

    public long getTotalTagDuration() {
        return this.totalTagDuration;
    }

    public int getTotalScenariosPassed() {
        return this.scenarioCounter.getValueFor(Status.PASSED);
    }

    public int getTotalScenariosFailed() {
        return this.scenarioCounter.getValueFor(Status.FAILED);
    }

    private void processFeatures() {
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                ResultsWithMatch[] steps;
                this.scenarioCounter.incrementFor(scenario.getStatus());
                for (Tag tag : scenario.getTags()) {
                    this.tagCounter.incrementFor(scenario.getStatus());
                    TagObject tagObject = this.addTagObject(tag.getName());
                    this.processTag(tagObject, scenario);
                }
                for (Step step : steps = scenario.getSteps()) {
                    this.stepStatusCounter.incrementFor(step.getStatus());
                    this.totalDuration += step.getDuration();
                }
                this.countSteps(steps);
                this.countSteps(scenario.getBefore());
                this.countSteps(scenario.getAfter());
            }
        }
    }

    private void processTag(TagObject tag, Scenario scenario) {
        Step[] steps;
        tag.addScenarios(scenario);
        for (Step step : steps = scenario.getSteps()) {
            this.tagStatusCounter.incrementFor(step.getStatus());
            this.totalTagDuration += step.getDuration();
        }
        this.totalTagSteps += steps.length;
    }

    private void countSteps(ResultsWithMatch[] steps) {
        for (ResultsWithMatch step : steps) {
            Result result;
            StepObject stepObject;
            String methodName = null;
            Match match = step.getMatch();
            if (match != null) {
                methodName = match.getLocation();
            }
            if ((stepObject = this.allSteps.get(methodName)) == null) {
                stepObject = new StepObject(methodName);
            }
            if ((result = step.getResult()) != null) {
                stepObject.addDuration(result.getDuration(), result.getStatus());
            } else {
                stepObject.addDuration(0L, Status.FAILED.name());
            }
            this.allSteps.put(methodName, stepObject);
        }
    }

    private TagObject addTagObject(String name) {
        TagObject tagObject = this.allTags.get(name);
        if (tagObject == null) {
            tagObject = new TagObject(name);
            this.allTags.put(tagObject.getTagName(), tagObject);
        }
        return tagObject;
    }
}

