/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.qqandroid.utils.cryptor;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDH;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDHKeyPair;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDHKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00060\u000fj\u0002`\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPairImpl;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPair;", "delegate", "Ljava/security/KeyPair;", "(Ljava/security/KeyPair;)V", "initialShareKey", "", "getInitialShareKey", "()[B", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHPrivateKey;", "getPrivateKey", "()Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHPublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "mirai-core-qqandroid"})
public final class ECDHKeyPairImpl
implements ECDHKeyPair {
    @NotNull
    private final byte[] initialShareKey;
    private final KeyPair delegate;

    @Override
    @NotNull
    public PrivateKey getPrivateKey() {
        PrivateKey privateKey = this.delegate.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"delegate.private");
        return privateKey;
    }

    @Override
    @NotNull
    public PublicKey getPublicKey() {
        PublicKey publicKey = this.delegate.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"delegate.public");
        return publicKey;
    }

    @Override
    @NotNull
    public byte[] getInitialShareKey() {
        return this.initialShareKey;
    }

    public ECDHKeyPairImpl(@NotNull KeyPair delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.initialShareKey = ECDH.Companion.calculateShareKey(this.getPrivateKey(), ECDHKt.getInitialPublicKey());
    }
}

