/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.qqandroid.utils.cryptor;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.qqandroid.utils.MiraiPlatformUtils;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDH;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDHKeyPair;
import net.mamoe.mirai.qqandroid.utils.cryptor.ECDHKeyPairImpl;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDH;", "", "keyPair", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPair;", "(Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPair;)V", "getKeyPair", "()Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPair;", "calculateShareKeyByPeerPublicKey", "", "peerPublicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHPublicKey;", "toString", "", "Companion", "mirai-core-qqandroid"})
public final class ECDH {
    @NotNull
    private final ECDHKeyPair keyPair;
    private static final boolean isECDHAvailable;
    public static final Companion Companion;

    @NotNull
    public final byte[] calculateShareKeyByPeerPublicKey(@NotNull PublicKey peerPublicKey) {
        Intrinsics.checkNotNullParameter((Object)peerPublicKey, (String)"peerPublicKey");
        return Companion.calculateShareKey(this.keyPair.getPrivateKey(), peerPublicKey);
    }

    @NotNull
    public String toString() {
        return "ECDH(keyPair=" + this.keyPair + ')';
    }

    @NotNull
    public final ECDHKeyPair getKeyPair() {
        return this.keyPair;
    }

    public ECDH(@NotNull ECDHKeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.keyPair = keyPair;
    }

    static {
        Object object;
        Companion = new Companion(null);
        boolean bl = false;
        try {
            Object object2;
            object = Result.Companion;
            boolean bl2 = false;
            Companion.1.1 $fun$testECDH$1 = Companion.1.1.INSTANCE;
            boolean bl3 = false;
            try {
                object2 = Result.Companion;
                boolean bl4 = false;
                Companion.1.1.INSTANCE.invoke();
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object2 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (!Result.isSuccess-impl((Object)object2)) {
                if (Security.getProvider("BC") != null) {
                    Security.removeProvider("BC");
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                $fun$testECDH$1.invoke();
            }
            Unit unit = Unit.INSTANCE;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl8 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        isECDHAvailable = Result.isSuccess-impl((Object)object);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rJ\u0012\u0010\u000e\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDH$Companion;", "", "()V", "isECDHAvailable", "", "()Z", "calculateShareKey", "", "privateKey", "Ljava/security/PrivateKey;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHPrivateKey;", "publicKey", "Ljava/security/PublicKey;", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHPublicKey;", "constructPublicKey", "key", "generateKeyPair", "Lnet/mamoe/mirai/qqandroid/utils/cryptor/ECDHKeyPair;", "mirai-core-qqandroid"})
    public static final class Companion {
        public final boolean isECDHAvailable() {
            return isECDHAvailable;
        }

        @NotNull
        public final ECDHKeyPair generateKeyPair() {
            if (!this.isECDHAvailable()) {
                return ECDHKeyPair.DefaultStub.INSTANCE;
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH");
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator it = keyPairGenerator;
            boolean bl3 = false;
            it.initialize(new ECGenParameterSpec("secp192k1"));
            Unit unit = Unit.INSTANCE;
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"KeyPairGenerator.getInst\u2026            .genKeyPair()");
            KeyPair keyPair2 = keyPair;
            return new ECDHKeyPairImpl(keyPair2);
        }

        @NotNull
        public final byte[] calculateShareKey(@NotNull PrivateKey privateKey, @NotNull PublicKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            KeyAgreement instance = KeyAgreement.getInstance("ECDH", "BC");
            instance.init(privateKey);
            instance.doPhase(publicKey, true);
            byte[] byArray = instance.generateSecret();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"instance.generateSecret()");
            return MiraiPlatformUtils.md5$default(MiraiPlatformUtils.INSTANCE, byArray, 0, 0, 6, null);
        }

        @NotNull
        public final PublicKey constructPublicKey(@NotNull byte[] key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new X509EncodedKeySpec(key));
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"KeyFactory.getInstance(\"\u2026(X509EncodedKeySpec(key))");
            return publicKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

