/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.raytrace;

import java.lang.ref.WeakReference;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Vector;
import net.malisis.core.util.raytrace.Raytrace;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RaytraceBlock
extends Raytrace {
    private WeakReference<World> world;
    private BlockPos pos;
    private Block block;

    public RaytraceBlock(World world, Ray ray, BlockPos pos) {
        super(ray);
        this.world = new WeakReference<World>(world);
        this.pos = pos;
        this.block = this.world().func_180495_p(pos).func_177230_c();
    }

    public RaytraceBlock(World world, Point src, Vector v, BlockPos pos) {
        this(world, new Ray(src, v), pos);
    }

    public RaytraceBlock(World world, Point src, Point dest, BlockPos pos) {
        this(world, new Ray(src, new Vector(src, dest)), pos);
        this.dest = dest;
    }

    public RaytraceBlock(World world, Vec3 src, Vec3 dest, BlockPos pos) {
        this(world, new Ray(src, dest), pos);
        this.dest = new Point(dest);
    }

    public World world() {
        return (World)this.world.get();
    }

    public MovingObjectPosition trace() {
        if (!(this.block instanceof IBoundingBox)) {
            return this.block.func_180636_a(this.world(), this.pos, this.ray.origin.toVec3(), this.dest.toVec3());
        }
        IBoundingBox block = (IBoundingBox)this.block;
        AxisAlignedBB[] aabbs = block.getRayTraceBoundingBox((IBlockAccess)this.world(), this.pos, this.world().func_180495_p(this.pos));
        Pair<EnumFacing, Point> closest = super.trace(AABBUtils.offset(this.pos, aabbs));
        if (closest == null) {
            return null;
        }
        return new MovingObjectPosition(((Point)closest.getRight()).toVec3(), (EnumFacing)closest.getLeft(), this.pos);
    }
}

