/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.blockdata.BlockDataHandler;
import net.malisis.core.util.multiblock.MultiBlockAccess;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MultiBlock
implements Iterable<MBlockState> {
    public static String ORIGIN_BLOCK_DATA = "malisiscore:multiBlockOrigin";
    protected Map<BlockPos, MBlockState> states = new HashMap<BlockPos, MBlockState>();
    protected BlockPos offset = new BlockPos(0, 0, 0);
    protected PropertyDirection property = DirectionalComponent.HORIZONTAL;
    private int rotation;
    private boolean bulkPlace;
    private boolean bulkBreak;

    public void setOffset(BlockPos offset) {
        this.offset = offset;
        this.buildStates();
    }

    public void setPropertyDirection(PropertyDirection property) {
        this.property = property;
    }

    public void setRotation(IBlockState state) {
        if (state == null || !state.func_177228_b().containsKey((Object)this.property)) {
            this.rotation = 0;
        } else {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)this.property);
            this.rotation = EnumFacingUtils.getRotationCount(direction);
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setBulkProcess(boolean bulkPlace, boolean bulkBreak) {
        this.bulkPlace = bulkPlace;
        this.bulkBreak = bulkBreak;
    }

    public boolean isBulkPlace() {
        return this.bulkPlace;
    }

    public boolean isBulkBreak() {
        return this.bulkBreak;
    }

    public boolean isFromMultiblock(World world, BlockPos pos) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, pos);
        if (origin == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(origin);
        this.setRotation(state);
        for (MBlockState mstate : this) {
            if (!(mstate = mstate.rotate(this.rotation).offset(pos)).getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public MBlockState getState(BlockPos pos) {
        pos = BlockPosUtils.rotate(pos, 4 - this.rotation);
        return this.states.get(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos, IBlockState state, boolean placeOrigin) {
        this.setRotation(state);
        for (MBlockState mstate : this) {
            if ((mstate = mstate.rotate(this.rotation).offset(pos)).getPos().equals((Object)pos) && !placeOrigin || world.func_180495_p(mstate.getPos()).func_177230_c().func_176200_f(world, mstate.getPos())) continue;
            return false;
        }
        return true;
    }

    public void placeBlocks(World world, BlockPos pos, IBlockState state, boolean placeOrigin) {
        this.setRotation(state);
        for (MBlockState mstate : this) {
            if ((mstate = mstate.rotate(this.rotation).offset(pos)).getPos().equals((Object)pos) && !placeOrigin) continue;
            BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, mstate.getPos(), pos);
            mstate.placeBlock(world, 2);
        }
        BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, pos, pos);
    }

    public void breakBlocks(World world, BlockPos pos, IBlockState state) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, pos);
        if (origin == null) {
            world.func_175698_g(pos);
            return;
        }
        if (!pos.equals((Object)origin)) {
            this.breakBlocks(world, origin, world.func_180495_p(origin));
            return;
        }
        BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, origin);
        this.setRotation(state);
        for (MBlockState mstate : this) {
            if (!(mstate = mstate.rotate(this.rotation).offset(origin)).matchesWorld((IBlockAccess)world)) continue;
            mstate.breakBlock(world, 2);
            BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, mstate.getPos());
        }
    }

    public boolean isComplete(World world, BlockPos pos) {
        return this.isComplete(world, pos, null);
    }

    public boolean isComplete(World world, BlockPos pos, MBlockState newState) {
        this.setRotation(world.func_180495_p(pos));
        MultiBlockAccess mba = new MultiBlockAccess(this, (IBlockAccess)world);
        for (MBlockState mstate : this) {
            boolean matches = (mstate = new MBlockState((IBlockAccess)mba, mstate.getPos()).offset(pos)).matchesWorld((IBlockAccess)world);
            if (!matches) {
                mstate.matchesWorld((IBlockAccess)world);
            }
            if (matches || newState != null && mstate.equals(newState)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<MBlockState> iterator() {
        return this.states.values().iterator();
    }

    protected abstract void buildStates();

    public static void registerBlockData() {
        BlockDataHandler.registerBlockData(ORIGIN_BLOCK_DATA, BlockPosUtils::fromBytes, BlockPosUtils::toBytes);
    }

    public static BlockPos getOrigin(IBlockAccess world, BlockPos pos) {
        BlockPos origin = (BlockPos)BlockDataHandler.getData(ORIGIN_BLOCK_DATA, world, pos);
        if (origin != null && IBlockComponent.getComponent(MultiBlockComponent.class, world.func_180495_p(origin).func_177230_c()) == null) {
            origin = null;
            BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, world, pos);
        }
        return world != null && pos != null ? origin : null;
    }

    public static boolean isOrigin(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null && pos.equals((Object)MultiBlock.getOrigin(world, pos));
    }
}

