/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.Silenced;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityUtils {
    @SideOnly(value=Side.CLIENT)
    private static TileEntity currentTileEntity;
    @SideOnly(value=Side.CLIENT)
    private static MalisisGui currenGui;

    public static <T> T getTileEntity(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return (T)(te != null ? Silenced.get(() -> clazz.cast(te)) : null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void linkTileEntityToGui(TileEntity te, MalisisGui gui) {
        currentTileEntity = te;
        currenGui = gui;
        currenGui.updateGui();
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGui(TileEntity te) {
        if (te != currentTileEntity) {
            return;
        }
        currenGui.updateGui();
    }

    public static AxisAlignedBB getRenderingBounds(TileEntity tileEntity) {
        Block block = tileEntity.func_145838_q();
        BlockPos pos = tileEntity.func_174877_v();
        World world = tileEntity.func_145831_w();
        AxisAlignedBB aabb = null;
        if (block instanceof IBoundingBox) {
            aabb = AABBUtils.combine(((IBoundingBox)block).getRenderBoundingBox((IBlockAccess)world, pos, world.func_180495_p(pos)));
            aabb = AABBUtils.offset(pos, aabb);
        }
        return aabb != null ? aabb : AABBUtils.identity(pos);
    }
}

