/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.util.Vector;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class Point {
    public double x;
    public double y;
    public double z;

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Point(Vec3 v) {
        this.x = v.field_72450_a;
        this.y = v.field_72448_b;
        this.z = v.field_72449_c;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point add(Vector v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Point add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public boolean isInside(AxisAlignedBB aabb) {
        return this.x >= aabb.field_72340_a && this.x <= aabb.field_72336_d && this.y >= aabb.field_72338_b && this.y <= aabb.field_72337_e && this.z >= aabb.field_72339_c && this.z <= aabb.field_72334_f;
    }

    public Vec3 toVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public boolean equals(Point p) {
        if (p == null) {
            return false;
        }
        return this.x == p.x && this.y == p.y && this.z == p.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public static double distanceSquared(Point p1, Point p2) {
        double x = p2.x - p1.x;
        double y = p2.y - p1.y;
        double z = p2.z - p1.z;
        return x * x + y * y + z * z;
    }

    public static double distance(Point p1, Point p2) {
        double x = p2.x - p1.x;
        double y = p2.y - p1.y;
        double z = p2.z - p1.z;
        return Math.sqrt(x * x + y * y + z * z);
    }
}

