/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.MalisisBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemUtils {
    public static final int FULL_STACK = -1;
    public static final int HALF_STACK = -2;

    public static boolean areItemStacksStackable(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77985_e() && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1);
    }

    public static IBlockState getStateFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block == null) {
            return null;
        }
        if (block instanceof MalisisBlock) {
            return ((MalisisBlock)block).getStateFromItemStack(itemStack);
        }
        return block.func_176203_a(itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()));
    }

    public static ItemStack getItemStackFromState(IBlockState state) {
        if (state == null) {
            return null;
        }
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
    }

    public static class ItemStackSplitter {
        public ItemStack source;
        public ItemStack split;
        public int amount;

        public ItemStackSplitter(ItemStack source) {
            this.source = source;
        }

        public ItemStack split(int amount) {
            if (this.source == null) {
                this.split = null;
                return null;
            }
            if (amount == -1) {
                amount = this.source.field_77994_a;
            } else if (amount == -2) {
                amount = (int)Math.ceil((float)this.source.field_77994_a / 2.0f);
            }
            this.amount = Math.min(amount, this.source.field_77994_a);
            this.split = this.source.func_77979_a(this.amount);
            if (this.source.field_77994_a <= 0) {
                this.source = null;
            }
            return this.split;
        }
    }

    public static class ItemStacksMerger {
        public ItemStack merge;
        public ItemStack into;
        public int nbMerged = -1;

        public ItemStacksMerger(ItemStack merge, ItemStack into) {
            this.merge = merge;
            this.into = into;
        }

        public boolean merge() {
            return this.merge(-1);
        }

        public boolean merge(int amount) {
            int max = 64;
            if (this.into != null) {
                max = this.into.func_77976_d();
            } else if (this.merge != null) {
                max = this.merge.func_77976_d();
            }
            return this.merge(amount, max);
        }

        public boolean merge(int amount, int intoMaxStackSize) {
            this.nbMerged = 0;
            if (!this.canMerge()) {
                return false;
            }
            if (this.merge == null) {
                return false;
            }
            if (amount == -1) {
                amount = this.merge.field_77994_a;
            }
            amount = Math.min(amount, this.merge.field_77994_a);
            if (this.into == null) {
                this.nbMerged = Math.min(amount, intoMaxStackSize);
                this.into = this.merge.func_77946_l();
                this.into.field_77994_a = this.nbMerged;
                this.merge.field_77994_a -= this.into.field_77994_a;
                if (this.merge.field_77994_a <= 0) {
                    this.merge = null;
                }
                return true;
            }
            this.nbMerged = Math.min(intoMaxStackSize, this.into.func_77976_d()) - this.into.field_77994_a;
            if (this.nbMerged == 0) {
                return false;
            }
            this.nbMerged = Math.min(this.nbMerged, amount);
            this.merge.field_77994_a -= this.nbMerged;
            if (this.merge.field_77994_a == 0) {
                this.merge = null;
            }
            this.into.field_77994_a += this.nbMerged;
            return true;
        }

        public boolean canMerge() {
            return this.merge == null || this.into == null || ItemUtils.areItemStacksStackable(this.merge, this.into);
        }
    }
}

