/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class EntityUtils {
    private static EnumFacing[] facings = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
    private static Method getPlayerInstance;
    private static Field playersWatchingChunk;

    public static void spawnEjectedItem(World world, BlockPos pos, ItemStack itemStack) {
        if (itemStack == null || world.field_72995_K) {
            return;
        }
        float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), itemStack);
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
    }

    public static EntityPlayerMP findPlayerFromUUID(UUID uuid) {
        List listPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : listPlayers) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static EnumFacing getEntityFacing(Entity entity) {
        return EntityUtils.getEntityFacing(entity, false);
    }

    public static EnumFacing getEntityFacing(Entity entity, boolean sixWays) {
        return facings[EntityUtils.getEntityRotation(entity, sixWays)];
    }

    public static int getEntityRotation(Entity entity) {
        return EntityUtils.getEntityRotation(entity, false);
    }

    public static int getEntityRotation(Entity entity, boolean sixWays) {
        if (entity == null) {
            return 6;
        }
        float pitch = entity.field_70125_A;
        if (sixWays && pitch < -45.0f) {
            return 4;
        }
        if (sixWays && pitch > 45.0f) {
            return 5;
        }
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) + 2 & 3;
    }

    public static boolean isEquipped(EntityPlayer player, Item item) {
        return player != null && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == item;
    }

    public static boolean isEquipped(EntityPlayer player, ItemStack itemStack) {
        return EntityUtils.isEquipped(player, itemStack != null ? itemStack.func_77973_b() : null);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(Chunk chunk) {
        return EntityUtils.getPlayersWatchingChunk((WorldServer)chunk.func_177412_p(), chunk.field_76635_g, chunk.field_76647_h);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(WorldServer world, int x, int z) {
        if (playersWatchingChunk == null) {
            return new ArrayList<EntityPlayerMP>();
        }
        try {
            Object playerInstance = getPlayerInstance.invoke((Object)world.func_73040_p(), x, z, false);
            if (playerInstance == null) {
                return new ArrayList<EntityPlayerMP>();
            }
            return (List)playersWatchingChunk.get(playerInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            MalisisCore.log.info("Failed to get players watching chunk :", (Throwable)e);
            return new ArrayList<EntityPlayerMP>();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer, IBlockState ... states) {
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.func_180495_p(pos)};
        }
        int nb = 4;
        EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)nb;
                    int id = Block.func_176210_f((IBlockState)states[world.field_73012_v.nextInt(states.length)]);
                    EntityDiggingFX fx = (EntityDiggingFX)factory.func_178902_a(0, world, fxX, fxY, fxZ, fxX - (double)pos.func_177958_n() - 0.5, fxY - (double)pos.func_177956_o() - 0.5, fxZ - (double)pos.func_177952_p() - 0.5, new int[]{id});
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer, IBlockState ... states) {
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.func_180495_p(target.func_178782_a())};
        }
        Block block = world.func_180495_p(target.func_178782_a()).func_177230_c();
        double fxX = (double)target.func_178782_a().func_177958_n() + world.field_73012_v.nextDouble();
        double fxY = (double)target.func_178782_a().func_177956_o() + world.field_73012_v.nextDouble();
        double fxZ = (double)target.func_178782_a().func_177952_p() + world.field_73012_v.nextDouble();
        switch (target.field_178784_b) {
            case DOWN: {
                fxY = (double)target.func_178782_a().func_177956_o() + block.func_149665_z() - (double)0.1f;
                break;
            }
            case UP: {
                fxY = (double)target.func_178782_a().func_177956_o() + block.func_149669_A() + (double)0.1f;
                break;
            }
            case NORTH: {
                fxZ = (double)target.func_178782_a().func_177952_p() + block.func_149706_B() - (double)0.1f;
                break;
            }
            case SOUTH: {
                fxZ = (double)target.func_178782_a().func_177952_p() + block.func_149669_A() + (double)0.1f;
                break;
            }
            case EAST: {
                fxX = (double)target.func_178782_a().func_177958_n() + block.func_149753_y() + (double)0.1f;
                break;
            }
            case WEST: {
                fxX = (double)target.func_178782_a().func_177958_n() + block.func_149704_x() + (double)0.1f;
                break;
            }
        }
        int id = Block.func_176210_f((IBlockState)states[world.field_73012_v.nextInt(states.length)]);
        EntityDiggingFX.Factory factory = new EntityDiggingFX.Factory();
        EntityDiggingFX fx = (EntityDiggingFX)factory.func_178902_a(0, world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, new int[]{id});
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        effectRenderer.func_78873_a((EntityFX)fx);
    }

    static {
        try {
            getPlayerInstance = AsmUtils.changeMethodAccess(PlayerManager.class, "getPlayerInstance", "func_72690_a", "IIZ");
            Class<?> clazz = Class.forName("net.minecraft.server.management.PlayerManager$PlayerInstance");
            playersWatchingChunk = AsmUtils.changeFieldAccess(clazz, "playersWatchingChunk", "field_73263_b");
        }
        catch (ClassNotFoundException e) {
            MalisisCore.log.error("Failed to get PlayerInstance class.", (Throwable)e);
        }
    }
}

