/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.IModelLoader;
import net.malisis.core.renderer.model.loader.ObjFileImporter;
import net.malisis.core.renderer.model.loader.TextureModelLoader;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;

public class MalisisModel
implements IFlexibleBakedModel,
ITransformable.Translate,
ITransformable.Rotate,
ITransformable.Scale,
Iterable<Shape> {
    protected Map<String, Shape> shapes = new HashMap<String, Shape>();

    public MalisisModel() {
    }

    public MalisisModel(Shape ... shapes) {
        this.addShapes(shapes);
    }

    public MalisisModel(IModelLoader loader) {
        this.load(loader);
    }

    public MalisisModel(ResourceLocation resource) {
        if (resource == null) {
            return;
        }
        IModelLoader loader = null;
        if (resource.func_110623_a().endsWith(".obj")) {
            loader = new ObjFileImporter(resource);
        }
        if (resource.func_110623_a().endsWith(".png")) {
            loader = new TextureModelLoader(resource);
        }
        if (loader != null) {
            this.load(loader);
        } else {
            MalisisCore.log.error("[MalisisModel] No loader determined for {}.", new Object[]{resource.func_110623_a()});
        }
    }

    protected void load(IModelLoader loader) {
        if (loader == null) {
            return;
        }
        this.shapes = loader.getShapes();
        this.storeState();
    }

    public void addShapes(Shape ... shapes) {
        for (Shape shape : shapes) {
            this.addShape(shape);
        }
    }

    public void addShape(Shape shape) {
        this.addShape("Shape_" + (this.shapes.size() + 1), shape);
    }

    public void addShape(String name, Shape shape) {
        if (shape == null) {
            return;
        }
        this.shapes.put(name.toLowerCase(), shape);
    }

    public Shape getShape(String name) {
        return this.shapes.get(name.toLowerCase());
    }

    public void render(MalisisRenderer renderer) {
        this.render(renderer, (RenderParameters)null);
    }

    public void render(MalisisRenderer renderer, RenderParameters rp) {
        for (String name : this.shapes.keySet()) {
            this.render(renderer, name, rp);
        }
    }

    public void render(MalisisRenderer renderer, String name) {
        this.render(renderer, name, null);
    }

    public void render(MalisisRenderer renderer, String name, RenderParameters rp) {
        Shape shape = this.shapes.get(name);
        if (shape != null) {
            renderer.drawShape(shape, rp);
        }
    }

    public void storeState() {
        for (Shape s : this) {
            s.storeState();
        }
    }

    public void resetState() {
        for (Shape s : this) {
            s.resetState();
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        for (Shape s : this) {
            s.translate(x, y, z);
        }
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        for (Shape s : this) {
            s.rotate(angle, x, y, z, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public void scale(float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        for (Shape s : this) {
            s.scale(x, y, z, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.shapes.values().iterator();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return null;
    }

    public List<BakedQuad> func_177551_a(EnumFacing side) {
        return this.getQuads(side);
    }

    public List<BakedQuad> func_177550_a() {
        return this.getQuads(null);
    }

    public List<BakedQuad> getQuads(EnumFacing side) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Shape s : this) {
            for (Face f : s.getFaces()) {
                if (f.getParameters().direction.get() != side) continue;
                quads.add(f.toBakedQuad());
            }
        }
        return quads;
    }

    public VertexFormat getFormat() {
        return DefaultVertexFormats.field_176600_a;
    }
}

