/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import java.util.EnumMap;
import java.util.Map;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class PropertyEnumIconProvider<T extends Enum<T>>
implements IBlockIconProvider {
    private PropertyEnum property;
    private MalisisIcon defaultIcon;
    private EnumMap<T, MalisisIcon> icons;

    public PropertyEnumIconProvider(PropertyEnum property, Class<T> enumClass, String defaultName) {
        this.property = property;
        this.icons = new EnumMap(enumClass);
        this.defaultIcon = new MalisisIcon(defaultName);
    }

    public PropertyEnumIconProvider(PropertyEnum property, Class<T> enumClass, MalisisIcon defaultIcon) {
        this.property = property;
        this.icons = new EnumMap(enumClass);
        this.defaultIcon = defaultIcon;
    }

    public PropertyEnumIconProvider(PropertyEnum property, Class<T> enumClass) {
        this(property, enumClass, (MalisisIcon)null);
    }

    public void setIcon(T enumValue, MalisisIcon icon) {
        this.icons.put(enumValue, icon);
    }

    public void setIcon(T enumValue, String iconName) {
        this.icons.put(enumValue, new MalisisIcon(iconName));
    }

    @Override
    public void registerIcons(TextureMap map) {
        if (this.defaultIcon != null) {
            this.defaultIcon = this.defaultIcon.register(map);
        }
        for (Map.Entry<T, MalisisIcon> entry : this.icons.entrySet()) {
            entry.setValue(entry.getValue().register(map));
        }
    }

    @Override
    public MalisisIcon getIcon() {
        return this.defaultIcon;
    }

    public MalisisIcon getIcon(T value) {
        MalisisIcon icon = this.icons.get(value);
        return icon != null ? icon : this.getIcon();
    }

    @Override
    public MalisisIcon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        return this.getIcon((Enum)((Object)state.func_177229_b((IProperty)this.property)));
    }

    @Override
    public MalisisIcon getIcon(ItemStack itemStack, EnumFacing facing) {
        if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
            return this.getIcon();
        }
        ItemBlock ib = (ItemBlock)itemStack.func_77973_b();
        if (!(ib.func_179223_d() instanceof MalisisBlock)) {
            return this.getIcon();
        }
        IBlockState state = ((MalisisBlock)ib.func_179223_d()).getStateFromItemStack(itemStack);
        return this.getIcon((Enum)((Object)state.func_177229_b((IProperty)this.property)));
    }
}

