/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import java.util.function.Function;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class FlexibleBlockIconProvider
implements IBlockIconProvider {
    private Block block;
    private MalisisIcon defaultIcon;
    private StateFacingFunc stateFacingFunc = null;

    public FlexibleBlockIconProvider(Block block, MalisisIcon defaultIcon, StateFacingFunc stateFacingFunc) {
        this.block = block;
        this.defaultIcon = defaultIcon;
        this.stateFacingFunc = stateFacingFunc;
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        if (this.defaultIcon != null) {
            this.defaultIcon = this.defaultIcon.register(textureMap);
        }
        if (this.stateFacingFunc == null) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            for (Object state : this.block.func_176194_O().func_177619_a()) {
                MalisisIcon icon = this.stateFacingFunc.apply((IBlockState)state, side);
                if (icon == null) continue;
                icon.register(textureMap);
            }
        }
    }

    @Override
    public MalisisIcon getIcon() {
        return this.defaultIcon;
    }

    @Override
    public MalisisIcon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        if (this.stateFacingFunc != null) {
            return this.stateFacingFunc.apply(state, side);
        }
        return this.getIcon();
    }

    public static interface StateFacingFunc {
        public MalisisIcon apply(IBlockState var1, EnumFacing var2);
    }

    public static interface FacingFunc
    extends Function<EnumFacing, MalisisIcon> {
    }

    public static interface StateFunc
    extends Function<IBlockState, MalisisIcon> {
    }
}

