/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;

public class MalisisIcon
extends TextureAtlasSprite {
    private static Field mapRegisteredSprites = AsmUtils.changeFieldAccess(TextureMap.class, "mapRegisteredSprites", "field_110574_e");
    public static MalisisIcon missing = new MalisisIcon("missingno");
    protected int sheetWidth;
    protected int sheetHeight;
    protected boolean flippedU = false;
    protected boolean flippedV = false;
    protected int rotation = 0;
    protected Set<MalisisIcon> dependants = new HashSet<MalisisIcon>();

    public MalisisIcon() {
        super("");
        this.field_110980_m = 1.0f;
        this.field_110978_o = 1.0f;
    }

    public MalisisIcon(String name) {
        super(name);
        this.field_110980_m = 1.0f;
        this.field_110978_o = 1.0f;
    }

    public MalisisIcon(MalisisIcon baseIcon) {
        super(baseIcon.func_94215_i());
        this.field_110980_m = 1.0f;
        this.field_110978_o = 1.0f;
        baseIcon.addDependant(this);
    }

    public MalisisIcon(String name, float u, float v, float U, float V) {
        this(name);
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public MalisisIcon(TextureAtlasSprite icon) {
        this(icon.func_94215_i());
        this.func_94217_a(icon);
    }

    public void addDependant(MalisisIcon icon) {
        this.dependants.add(icon);
    }

    public void setSize(int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public float func_94209_e() {
        return this.flippedU ? this.field_110980_m : this.field_110979_l;
    }

    public float func_94212_f() {
        return this.flippedU ? this.field_110979_l : this.field_110980_m;
    }

    public float func_94206_g() {
        return this.flippedV ? this.field_110978_o : this.field_110977_n;
    }

    public float func_94210_h() {
        return this.flippedV ? this.field_110977_n : this.field_110978_o;
    }

    public MalisisIcon flip(boolean horizontal, boolean vertical) {
        this.flippedU = horizontal;
        this.flippedV = vertical;
        return this;
    }

    public boolean isFlippedU() {
        return this.flippedU;
    }

    public boolean isFlippedV() {
        return this.flippedV;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void initIcon(MalisisIcon baseIcon, int width, int height, int x, int y, boolean rotated) {
        this.func_94217_a(baseIcon);
    }

    public MalisisIcon offset(int offsetX, int offsetY) {
        this.func_110971_a(this.sheetWidth, this.sheetHeight, this.func_130010_a() + offsetX, this.func_110967_i() + offsetY, this.isRotated());
        return this;
    }

    public MalisisIcon clip(int offsetX, int offsetY, int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
        this.offset(offsetX, offsetY);
        return this;
    }

    public MalisisIcon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        int offsetX = Math.round((float)this.field_130223_c * offsetXFactor);
        int offsetY = Math.round((float)this.field_130224_d * offsetYFactor);
        this.field_130223_c = Math.round((float)this.field_130223_c * widthFactor);
        this.field_130224_d = Math.round((float)this.field_130224_d * heightFactor);
        this.offset(offsetX, offsetY);
        return this;
    }

    public void func_110971_a(int width, int height, int x, int y, boolean rotated) {
        this.sheetWidth = width;
        this.sheetHeight = height;
        super.func_110971_a(width, height, x, y, rotated);
        for (TextureAtlasSprite textureAtlasSprite : this.dependants) {
            if (textureAtlasSprite instanceof MalisisIcon) {
                ((MalisisIcon)textureAtlasSprite).initIcon(this, width, height, x, y, rotated);
                continue;
            }
            this.func_94217_a(this);
        }
    }

    public void func_94217_a(TextureAtlasSprite base) {
        super.func_94217_a(base);
        for (int i = 0; i < base.func_110970_k(); ++i) {
            this.field_110976_a.add(base.func_147965_a(i));
        }
        if (base instanceof MalisisIcon) {
            MalisisIcon mbase = (MalisisIcon)base;
            this.sheetWidth = mbase.sheetWidth;
            this.sheetHeight = mbase.sheetHeight;
            this.flippedU = mbase.flippedU;
            this.flippedV = mbase.flippedV;
        }
    }

    public MalisisIcon copy() {
        MalisisIcon icon = new MalisisIcon();
        icon.func_94217_a(this);
        return icon;
    }

    public MalisisIcon register(TextureMap textureMap) {
        TextureAtlasSprite icon = textureMap.getTextureExtry(this.func_94215_i());
        if (icon instanceof MalisisIcon) {
            return (MalisisIcon)icon;
        }
        if (icon != null && icon.getClass() == TextureAtlasSprite.class) {
            return this.replaceRegisteredIcon(textureMap);
        }
        textureMap.setTextureEntry(this.func_94215_i(), (TextureAtlasSprite)this);
        return this;
    }

    private MalisisIcon replaceRegisteredIcon(TextureMap textureMap) {
        try {
            HashMap map = (HashMap)mapRegisteredSprites.get(textureMap);
            map.put(this.func_94215_i(), this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return this;
    }
}

