/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.item;

import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.icon.IIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class MalisisItemBlock
extends ItemBlock
implements IRegisterable {
    protected String name;
    protected IIconProvider iconProvider;

    public MalisisItemBlock(Block block) {
        super(block);
    }

    public MalisisItemBlock setName(String name) {
        this.name = name;
        super.func_77655_b(name);
        return this;
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.field_150939_a instanceof MalisisBlock) {
            IBlockState state = ((MalisisBlock)this.field_150939_a).getStateFromItemStack(itemStack);
            return ((MalisisBlock)this.field_150939_a).getUnlocalizedName(state);
        }
        return super.func_77667_c(itemStack);
    }

    @Override
    public String getRegistryName() {
        return this.name;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, itemStack)) {
            return false;
        }
        IBlockState placedState = this.checkMerge(itemStack, player, world, pos, side, hitX, hitY, hitZ, false);
        BlockPos p = pos;
        if (placedState == null) {
            p = pos.func_177972_a(side);
            float x = hitX - (float)side.func_82601_c();
            float y = hitY - (float)side.func_96559_d();
            float z = hitZ - (float)side.func_82599_e();
            placedState = this.checkMerge(itemStack, player, world, p, side, x, y, z, true);
        }
        if (placedState == null) {
            return super.func_180614_a(itemStack, player, world, pos, side, hitX, hitY, hitZ);
        }
        Block block = placedState.func_177230_c();
        if (world.func_72855_b(block.func_180640_a(world, p, placedState)) && world.func_180501_a(p, placedState, 3)) {
            world.func_72908_a((double)((float)p.func_177958_n() + 0.5f), (double)((float)p.func_177956_o() + 0.5f), (double)((float)p.func_177952_p() + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            --itemStack.field_77994_a;
        }
        return true;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack itemStack) {
        IMergedBlock mergedBlock = this.getMerged(world.func_180495_p(pos));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        mergedBlock = this.getMerged(world.func_180495_p(pos = pos.func_177972_a(side)));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        return super.func_179222_a(world, pos, side, player, itemStack);
    }

    private IMergedBlock getMerged(IBlockState state) {
        IMergedBlock mergedBlock = IBlockComponent.getComponent(IMergedBlock.class, state.func_177230_c());
        if (mergedBlock == null) {
            return null;
        }
        if (mergedBlock.mergeSelfOnly() && state.func_177230_c() != this.field_150939_a) {
            return null;
        }
        return mergedBlock;
    }

    private IBlockState checkMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, boolean offset) {
        IBlockState state = world.func_180495_p(pos);
        IMergedBlock mergedBlock = this.getMerged(state);
        if (mergedBlock == null || !mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return null;
        }
        return mergedBlock.mergeBlock(world, pos, state, itemStack, player, side, hitX, hitY, hitZ);
    }
}

