/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory.message;

import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class OpenInventoryMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public OpenInventoryMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (message.type == ContainerType.TYPE_TILEENTITY) {
            IInventoryProvider.IDirectInventoryProvider inventoryProvider = TileEntityUtils.getTileEntity(IInventoryProvider.IDirectInventoryProvider.class, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, message.pos);
            if (inventoryProvider != null) {
                MalisisInventory.open(player, inventoryProvider, message.windowId);
            }
        } else if (message.type == ContainerType.TYPE_ITEM) {
            ItemStack itemStack = player.func_71045_bC();
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IInventoryProvider.IDeferredInventoryProvider)) {
                return;
            }
            IInventoryProvider.IDeferredInventoryProvider inventoryProvider = (IInventoryProvider.IDeferredInventoryProvider)itemStack.func_77973_b();
            MalisisInventory.open(player, inventoryProvider, itemStack, message.windowId);
        }
    }

    public static void send(IInventoryProvider container, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(container, windowId);
        MalisisCore.network.sendTo(packet, player);
    }

    public static class Packet
    implements IMessage {
        private ContainerType type;
        private BlockPos pos;
        private int windowId;

        public Packet() {
        }

        public Packet(IInventoryProvider container, int windowId) {
            this.windowId = windowId;
            if (container instanceof TileEntity) {
                this.type = ContainerType.TYPE_TILEENTITY;
                this.pos = ((TileEntity)container).func_174877_v();
            }
            if (container instanceof Item) {
                this.type = ContainerType.TYPE_ITEM;
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.type = ContainerType.values()[buf.readByte()];
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            }
            this.windowId = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.type.ordinal());
            if (this.type == ContainerType.TYPE_TILEENTITY) {
                buf.writeInt(this.pos.func_177958_n());
                buf.writeInt(this.pos.func_177956_o());
                buf.writeInt(this.pos.func_177952_p());
            }
            buf.writeInt(this.windowId);
        }
    }

    public static enum ContainerType {
        TYPE_TILEENTITY,
        TYPE_ITEM;

    }
}

