/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory.message;

import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisMessage
public class InventoryActionMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public InventoryActionMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.SERVER);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
        if (message.windowId != c.field_75152_c || !(c instanceof MalisisInventoryContainer)) {
            return;
        }
        MalisisInventoryContainer container = (MalisisInventoryContainer)c;
        container.handleAction(message.action, message.inventoryId, message.slotNumber, message.code);
        container.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendAction(MalisisInventoryContainer.ActionType action, int inventoryId, int slotNumber, int code) {
        int windowId = Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75152_c;
        Packet packet = new Packet(action, inventoryId, slotNumber, code, windowId);
        MalisisCore.network.sendToServer(packet);
    }

    public static class Packet
    implements IMessage {
        private MalisisInventoryContainer.ActionType action;
        private int inventoryId;
        private int slotNumber;
        private int code;
        private int windowId;

        public Packet() {
        }

        public Packet(MalisisInventoryContainer.ActionType action, int inventoryId, int slotNumber, int code, int windowId) {
            this.action = action;
            this.inventoryId = inventoryId;
            this.slotNumber = slotNumber;
            this.code = code;
            this.windowId = windowId;
        }

        public void fromBytes(ByteBuf buf) {
            this.action = MalisisInventoryContainer.ActionType.values()[buf.readByte()];
            this.inventoryId = buf.readInt();
            this.slotNumber = buf.readInt();
            this.code = buf.readInt();
            this.windowId = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.action.ordinal());
            buf.writeInt(this.inventoryId);
            buf.writeInt(this.slotNumber);
            buf.writeInt(this.code);
            buf.writeInt(this.windowId);
        }
    }
}

