/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IInventoryProvider {

    public static interface IDeferredInventoryProvider<T>
    extends IInventoryProvider {
        public MalisisInventory getInventory(T var1);

        @SideOnly(value=Side.CLIENT)
        public MalisisGui getGui(T var1, MalisisInventoryContainer var2);

        default public MalisisInventory[] getInventories(T data) {
            return new MalisisInventory[]{this.getInventory(data)};
        }

        default public void clear(T data) {
            for (MalisisInventory inventory : this.getInventories(data)) {
                inventory.emptyInventory();
            }
        }

        default public void breakInventories(T data, World world, BlockPos pos) {
            for (MalisisInventory inventory : this.getInventories(data)) {
                inventory.breakInventory(world, pos);
            }
        }
    }

    public static interface IDirectInventoryProvider
    extends IInventoryProvider,
    IInventory {
        public MalisisInventory getInventory();

        default public MalisisInventory[] getInventories() {
            return new MalisisInventory[]{this.getInventory()};
        }

        @SideOnly(value=Side.CLIENT)
        public MalisisGui getGui(MalisisInventoryContainer var1);

        default public void func_174888_l() {
            for (MalisisInventory inventory : this.getInventories()) {
                inventory.emptyInventory();
            }
        }

        default public void breakInventories(World world, BlockPos pos) {
            for (MalisisInventory inventory : this.getInventories()) {
                inventory.breakInventory(world, pos);
            }
        }

        default public boolean func_145818_k_() {
            return this.getInventory() != null && this.getInventory().hasCustomName();
        }

        default public String func_70005_c_() {
            return this.getInventory() != null ? this.getInventory().getName() : null;
        }

        default public IChatComponent func_145748_c_() {
            return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        default public int func_70302_i_() {
            return this.getInventory() != null ? this.getInventory().size : 0;
        }

        default public ItemStack func_70301_a(int index) {
            return this.getInventory() != null ? this.getInventory().getItemStack(index) : null;
        }

        default public ItemStack func_70298_a(int index, int count) {
            return this.getInventory() != null ? new ItemUtils.ItemStackSplitter(this.getInventory().getItemStack(index)).split(count) : null;
        }

        default public ItemStack func_70304_b(int index) {
            return this.func_70301_a(index);
        }

        default public void func_70299_a(int index, ItemStack stack) {
            MalisisInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.setItemStack(index, stack);
            }
        }

        default public int func_70297_j_() {
            return this.getInventory() != null ? this.getInventory().getInventoryStackLimit() : 0;
        }

        default public void func_70296_d() {
        }

        default public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        default public void func_174889_b(EntityPlayer player) {
        }

        default public void func_174886_c(EntityPlayer player) {
        }

        default public boolean func_94041_b(int index, ItemStack stack) {
            MalisisInventory inventory = this.getInventory();
            if (inventory == null) {
                return false;
            }
            MalisisSlot slot = inventory.getSlot(index);
            return slot != null && slot.isItemValid(stack);
        }

        default public int func_174887_a_(int id) {
            return 0;
        }

        default public void func_174885_b(int id, int value) {
        }

        default public int func_174890_g() {
            return 0;
        }
    }
}

