/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;

public class UITab
extends UIComponent<UITab>
implements IGuiText<UITab> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    protected FontRenderOptions activeFro = new FontRenderOptions();
    protected FontRenderOptions hoveredFro = new FontRenderOptions();
    protected String label;
    protected UIImage image;
    protected boolean autoWidth = false;
    protected boolean autoHeight = false;
    protected UIContainer container;
    protected boolean active = false;
    protected int bgColor = 0xFFFFFF;

    public UITab(MalisisGui gui, String label) {
        super(gui);
        this.fro.color = 0x444444;
        this.activeFro.color = 0xFFFFFF;
        this.activeFro.shadow = true;
        this.hoveredFro.color = 0xFFFFA0;
        this.setSize(0, 0);
        this.setLabel(label);
        this.shape = new XYResizableGuiShape();
        this.iconProvider = new GuiIconProvider(null);
    }

    public UITab(MalisisGui gui, UIImage image) {
        super(gui);
        this.setSize(0, 0);
        this.setImage(image);
        this.shape = new XYResizableGuiShape();
        this.iconProvider = new GuiIconProvider(null);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UITab setFont(MalisisFont font) {
        this.font = font;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UITab setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    public FontRenderOptions getActiveFontRendererOptions() {
        return this.activeFro;
    }

    public UITab setActiveFontRendererOptions(FontRenderOptions fro) {
        this.activeFro = fro;
        return this;
    }

    public FontRenderOptions getHoveredFontRendererOptions() {
        return this.hoveredFro;
    }

    public UITab setHoveredFontRendererOptions(FontRenderOptions fro) {
        this.hoveredFro = fro;
        return this;
    }

    public UITab setLabel(String label) {
        this.image = null;
        this.label = label;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    public UITab setImage(UIImage image) {
        this.label = null;
        this.image = image;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    @Override
    public void setParent(UIComponent parent) {
        if (!(parent instanceof UITabGroup)) {
            throw new IllegalArgumentException("UITabs can only be added to UITabGroup");
        }
        super.setParent(parent);
    }

    @Override
    public UITab setSize(int width, int height) {
        this.autoWidth = width == 0;
        this.width = this.autoWidth ? this.calcAutoWidth() : width;
        this.autoHeight = height == 0;
        int n = this.height = this.autoHeight ? this.calcAutoHeight() : height;
        if (this.shape != null) {
            this.shape.setSize(this.width, this.height);
        }
        return this;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public UITab setContainer(UIContainer container) {
        this.container = container;
        return this;
    }

    public ComponentPosition getTabPosition() {
        return ((UITabGroup)this.parent).getTabPosition();
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UITab setBgColor(int color) {
        UIContainer cont;
        this.bgColor = color;
        if (this.parent != null && (cont = ((UITabGroup)this.parent).getAttachedContainer()) instanceof ITransformable.Color) {
            ((ITransformable.Color)((Object)cont)).setColor(color);
        }
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public UITab setActive(boolean active) {
        if (this.container == null) {
            this.active = active;
            return this;
        }
        if (this.active != active) {
            switch (this.getTabPosition()) {
                case TOP: 
                case BOTTOM: {
                    this.y += active ? -1 : 1;
                    this.height += active ? 2 : -2;
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.x += active ? -1 : 1;
                    this.width += active ? 2 : -2;
                }
            }
        }
        this.active = active;
        this.container.setVisible(active);
        this.container.setDisabled(!active);
        this.zIndex = this.container.getZIndex() + (active ? 1 : 0);
        this.fireEvent(new StateChangeEvent.ActiveStateChange<UITab>(this, active));
        return this;
    }

    private MalisisIcon getIcon() {
        if (this.parent == null) {
            return null;
        }
        return ((UITabGroup)this.parent).getIcons();
    }

    protected boolean isHorizontal() {
        if (this.parent == null) {
            return true;
        }
        ComponentPosition pos = ((UITabGroup)this.parent).getTabPosition();
        return pos == ComponentPosition.TOP || pos == ComponentPosition.BOTTOM;
    }

    private int calcAutoWidth() {
        if (this.label != null) {
            return (int)(this.font.getStringWidth(this.label, this.fro) + (float)(this.isHorizontal() ? 10 : 8));
        }
        if (this.image != null) {
            return this.image.getWidth() + 10;
        }
        return 8;
    }

    private int calcAutoHeight() {
        if (this.label != null) {
            return (int)(this.font.getStringHeight(this.fro) + (float)(this.isHorizontal() ? 8 : 10));
        }
        if (this.image != null) {
            return this.image.getHeight() + 10;
        }
        return 8;
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!(this.parent instanceof UITabGroup)) {
            return super.onClick(x, y);
        }
        if (!this.fireEvent(new UITabGroup.TabChangeEvent((UITabGroup)this.parent, this))) {
            return super.onClick(x, y);
        }
        ((UITabGroup)this.parent).setActiveTab(this);
        return true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.colorMultiplier.set(this.bgColor);
        ((GuiIconProvider)this.iconProvider).setIcon(this.getIcon());
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int w = this.label != null ? (int)this.font.getStringWidth(this.label, this.fro) : this.image.getWidth();
        int h = this.label != null ? (int)this.font.getStringHeight(this.fro) : this.image.getHeight();
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2 + 1;
        if (this.active) {
            switch (this.getTabPosition()) {
                case TOP: {
                    --y;
                    break;
                }
                case BOTTOM: {
                    ++y;
                    break;
                }
                case LEFT: {
                    --x;
                    break;
                }
                case RIGHT: {
                    ++x;
                }
            }
        }
        if (this.label != null) {
            FontRenderOptions fro = this.isHovered() ? this.hoveredFro : (this.active ? this.activeFro : this.fro);
            renderer.drawText(this.font, this.label, x, y, 1.0f, fro);
        } else if (this.image != null) {
            this.image.setPosition(this.screenX() + x, this.screenY() + y);
            this.image.setZIndex(this.zIndex);
            this.image.draw(renderer, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public String getPropertyString() {
        return "label : " + this.label + " | " + super.getPropertyString();
    }
}

