/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import java.util.Arrays;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;

public class UITooltip
extends UIComponent
implements IGuiText<UITooltip> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontRenderOptions fro = new FontRenderOptions();
    protected List<String> lines;
    protected int padding = 4;
    protected int delay = 0;
    protected Animation animation;

    public UITooltip(MalisisGui gui) {
        super(gui);
        this.setSize(16, 16);
        this.zIndex = 300;
        this.fro.color = 0xFFFFFF;
        this.fro.shadow = true;
        this.shape = new XYResizableGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(227, 31, 15, 15, 5));
        this.animation = new Animation(this, (Transformation)new AlphaTransform(0, 255).forTicks(2));
    }

    public UITooltip(MalisisGui gui, String text) {
        this(gui);
        this.setText(text);
    }

    public UITooltip(MalisisGui gui, int delay) {
        this(gui);
        this.setDelay(delay);
    }

    public UITooltip(MalisisGui gui, String text, int delay) {
        this(gui);
        this.setText(text);
        this.setDelay(delay);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UITooltip setFont(MalisisFont font) {
        this.font = font;
        this.calculateSize();
        return this;
    }

    @Override
    public FontRenderOptions getFontRenderOptions() {
        return this.fro;
    }

    @Override
    public UITooltip setFontRenderOptions(FontRenderOptions fro) {
        this.fro = fro;
        this.calculateSize();
        return this;
    }

    public UITooltip setText(String text) {
        this.lines = Arrays.asList(text.split("\\n"));
        this.calculateSize();
        return this;
    }

    public UITooltip setText(List<String> lines) {
        this.lines = lines;
        this.calculateSize();
        return this;
    }

    public UITooltip setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    protected int getOffsetX() {
        return 8;
    }

    protected int getOffsetY() {
        return -16;
    }

    protected void calculateSize() {
        this.width = Math.max(16, (int)this.font.getMaxStringWidth(this.lines, this.fro));
        this.width += this.padding * 2;
        this.height = (int)(this.lines.size() > 1 ? this.font.getStringHeight(this.fro) * (float)this.lines.size() : 8.0f);
        this.height += this.padding * 2;
    }

    public void animate() {
        if (this.delay == 0) {
            return;
        }
        this.setAlpha(0);
        this.getGui().animate(this.animation, this.delay);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.setPosition(mouseX + this.getOffsetX(), mouseY + this.getOffsetY());
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int x = mouseX + this.getOffsetX() + this.padding;
        int y = mouseY + this.getOffsetY() + this.padding;
        int i = 0;
        for (String str : this.lines) {
            int sy = y;
            if (i > 0) {
                sy += 2;
            }
            renderer.drawText(this.font, str, x, (float)sy + this.font.getStringHeight(this.fro) * (float)i, this.zIndex + 1, this.fro, false);
            ++i;
        }
    }
}

