/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;

public class UIPanel
extends UIContainer<UIPanel>
implements ITransformable.Color {
    protected int backgroundColor = -1;

    public UIPanel(MalisisGui gui) {
        super(gui);
        this.setPadding(3, 3);
        this.shape = new XYResizableGuiShape(5);
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(200, 15, 15, 15, 5));
    }

    public UIPanel(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public UIPanel(MalisisGui gui, String title) {
        this(gui);
        this.setTitle(title);
    }

    public UIPanel(MalisisGui gui, String title, int width, int height) {
        this(gui);
        this.setTitle(title);
        this.setSize(width, height);
    }

    public UIContainer setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setColor(int color) {
        this.setBackgroundColor(color);
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this, 1);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.useTexture.set(true);
        this.rp.alpha.set(255);
        this.rp.colorMultiplier.set(this.getBackgroundColor() != 0x404040 ? this.getBackgroundColor() : -1);
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
    }
}

