/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;

public class UIInventory
extends UIContainer<UIInventory> {
    private MalisisInventory inventory;
    private int numCols;
    private boolean hasTitle;

    public UIInventory(MalisisGui gui, String title, MalisisInventory inventory, int numCols) {
        super(gui, title != null ? title : inventory.getName(), 0, 0);
        this.hasTitle = title != null || inventory.hasCustomName();
        this.inventory = inventory;
        this.numCols = numCols;
        this.width = Math.min(inventory.getSizeInventory() * 18, numCols * 18);
        this.height = (int)Math.ceil((float)inventory.getSizeInventory() / (float)numCols) * 18 + (this.hasTitle ? 11 : 0);
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            this.addSlot(gui, inventory.getSlot(i), i);
        }
    }

    public UIInventory(MalisisGui gui, MalisisInventory inventory, int numCols) {
        this(gui, null, inventory, numCols);
    }

    public UIInventory(MalisisGui gui, String title, MalisisInventory inventory) {
        this(gui, title, inventory, 9);
    }

    public UIInventory(MalisisGui gui, MalisisInventory inventory) {
        this(gui, null, inventory, 9);
    }

    protected void addSlot(MalisisGui gui, MalisisSlot slot, int number) {
        UISlot uislot = new UISlot(gui, slot);
        int row = number / this.numCols;
        int col = number % this.numCols;
        uislot.setPosition(col * 18, row * 18 + (this.hasTitle ? 11 : 0));
        this.add(uislot);
    }
}

