/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.malisis.core.renderer.icon.GuiIcon;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class GuiTexture {
    protected ResourceLocation resourceLocation;
    protected int width;
    protected int height;

    public GuiTexture(ResourceLocation rl, int width, int height) {
        this.resourceLocation = rl;
        this.width = width;
        this.height = height;
    }

    public GuiTexture(File file) throws IOException {
        this(ImageIO.read(file), file.getName());
    }

    public GuiTexture(BufferedImage image, String name) {
        DynamicTexture dynTex = new DynamicTexture(image);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(name, dynTex);
    }

    public GuiTexture(ResourceLocation rl) {
        this(rl, 1, 1);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    private MalisisIcon createIcon(int x, int y, int width, int height) {
        MalisisIcon icon = new MalisisIcon();
        icon.setSize(width, height);
        icon.func_110971_a(this.width, this.height, x, y, false);
        return icon;
    }

    public GuiIcon getIcon(int x, int y, int width, int height) {
        return new GuiIcon(this.createIcon(x, y, width, height));
    }

    public GuiIcon getXYResizableIcon(int x, int y, int width, int height, int corner) {
        int w = width - corner * 2;
        int h = height - corner * 2;
        MalisisIcon[] icons = new MalisisIcon[]{this.createIcon(x, y, corner, corner), this.createIcon(x + corner, y, w, corner), this.createIcon(x + corner + w, y, corner, corner), this.createIcon(x, y + corner, corner, h), this.createIcon(x + corner, y + corner, w, h), this.createIcon(x + corner + w, y + corner, corner, h), this.createIcon(x, y + corner + h, corner, corner), this.createIcon(x + corner, y + corner + h, w, corner), this.createIcon(x + corner + w, y + corner + h, corner, corner)};
        return new GuiIcon(icons);
    }

    public GuiIcon getXResizableIcon(int x, int y, int width, int height, int side) {
        int w = width - side * 2;
        int h = height;
        MalisisIcon[] icons = new MalisisIcon[]{this.createIcon(x, y, side, h), this.createIcon(x + side, y, w, h), this.createIcon(x + side + w, y, side, h)};
        return new GuiIcon(icons);
    }

    public void delete() {
        Minecraft.func_71410_x().func_110434_K().func_147645_c(this.resourceLocation);
    }

    public String toString() {
        return this.resourceLocation + " [" + this.width + ", " + this.height + "]";
    }
}

