/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WallComponent
implements IBlockComponent,
IMergedBlock {
    public static PropertyBool CORNER = PropertyBool.func_177716_a((String)"corner");

    public PropertyBool getProperty() {
        return CORNER;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IBlockComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IBlockComponent[]{new DirectionalComponent()});
    }

    @Override
    public boolean canMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if (WallComponent.isCorner(state)) {
            return false;
        }
        return EnumFacingUtils.getRealSide(state, side) != EnumFacing.NORTH;
    }

    @Override
    public IBlockState mergeBlock(World world, BlockPos pos, IBlockState state, ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumFacing direction = DirectionalComponent.getDirection(state);
        EnumFacing realSide = EnumFacingUtils.getRealSide(state, side);
        if (!world.field_72995_K) {
            MalisisCore.message(hitX + ", " + hitY + ", " + hitZ);
        }
        if (realSide == EnumFacing.EAST && hitX == 1.0f) {
            return null;
        }
        if (realSide == EnumFacing.WEST && hitX == 0.0f) {
            return null;
        }
        if (realSide == EnumFacing.UP && hitY == 1.0f) {
            return null;
        }
        if (realSide == EnumFacing.DOWN && hitX == 0.0f) {
            return null;
        }
        boolean rotate = false;
        switch (direction) {
            case SOUTH: {
                rotate = hitX < 0.5f;
                break;
            }
            case NORTH: {
                rotate = hitX >= 0.5f;
                break;
            }
            case WEST: {
                rotate = hitZ < 0.5f;
                break;
            }
            case EAST: {
                rotate = hitZ >= 0.5f;
                break;
            }
        }
        if (rotate) {
            state = DirectionalComponent.rotate(state);
        }
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(true));
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return WallComponent.isCorner(state) ? 8 : 0;
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        boolean corner = WallComponent.isCorner(world, pos);
        if (type == BoundingBoxType.SELECTION && corner) {
            return AABBUtils.identities();
        }
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
        if (!corner) {
            return new AxisAlignedBB[]{aabb};
        }
        return new AxisAlignedBB[]{aabb, AABBUtils.rotate(aabb, -1)};
    }

    @Override
    public Boolean shouldSideBeRendered(Block block, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing realSide = EnumFacingUtils.getRealSide(state, side);
        if (realSide == EnumFacing.SOUTH || WallComponent.isCorner(state) && realSide == EnumFacing.EAST) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean isOpaqueCube(Block block) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block) {
        return false;
    }

    @Override
    public Integer quantityDropped(Block block, IBlockState state, int fortune, Random random) {
        return WallComponent.isCorner(state) ? 2 : 1;
    }

    public static boolean isCorner(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? WallComponent.isCorner(world.func_180495_p(pos)) : false;
    }

    public static boolean isCorner(IBlockState state) {
        WallComponent wc = IBlockComponent.getComponent(WallComponent.class, state.func_177230_c());
        if (wc == null) {
            return false;
        }
        PropertyBool property = wc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }
}

