/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;

public class SlabComponent
implements IBlockComponent,
IMergedBlock,
ISmartCull {
    private MalisisBlock singleSlab;
    private MalisisBlock doubleSlab;

    public SlabComponent(MalisisBlock singleSlab, MalisisBlock doubleSlab) {
        this.singleSlab = singleSlab;
        this.doubleSlab = doubleSlab;
        singleSlab.addComponent(this);
        doubleSlab.addComponent(this);
        doubleSlab.setName(singleSlab.getRegistryName() + "Double");
    }

    public boolean isDouble(Block block) {
        return block == this.doubleSlab;
    }

    public void register() {
        this.singleSlab.register();
        this.doubleSlab.register();
        GameData.getBlockItemMap().put(this.doubleSlab, Item.func_150898_a((Block)this.singleSlab));
    }

    public PropertyEnum getProperty() {
        return BlockSlab.field_176554_a;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    }

    @Override
    public Item getItem(Block block) {
        if (this.isDouble(block)) {
            return null;
        }
        return new MalisisItemBlock(this.singleSlab);
    }

    @Override
    public boolean canMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_177230_c() == this.singleSlab;
    }

    @Override
    public IBlockState mergeBlock(World world, BlockPos pos, IBlockState state, ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.doubleSlab.func_176223_P();
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.isDouble(block)) {
            return state;
        }
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)(facing != EnumFacing.DOWN && (facing == EnumFacing.UP || hitY <= 0.5f) ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    @Override
    public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        if (this.isDouble(block)) {
            return AABBUtils.identity();
        }
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        if (SlabComponent.isTop(world, pos)) {
            aabb = aabb.func_72317_d(0.0, 0.5, 0.0);
        }
        return aabb;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)((meta & 8) != 0 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return SlabComponent.isTop(state) ? 8 : 0;
    }

    @Override
    public Boolean isFullCube(Block block) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block) {
        return false;
    }

    @Override
    public Boolean isOpaqueCube(Block block) {
        return false;
    }

    @Override
    public Integer getMixedBrightnessForBlock(Block block, IBlockAccess world, BlockPos pos) {
        return null;
    }

    @Override
    public Item getItemDropped(Block block, IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.singleSlab);
    }

    @Override
    public Integer quantityDropped(Block block, IBlockState state, int fortune, Random random) {
        return this.isDouble(block) ? 2 : 1;
    }

    @Override
    public Integer getLightOpacity(Block block, IBlockAccess world, BlockPos pos) {
        return this.isDouble(block) ? 255 : 0;
    }

    public static boolean isTop(IBlockAccess world, BlockPos pos) {
        return world != null ? SlabComponent.isTop(world.func_180495_p(pos)) : false;
    }

    public static boolean isTop(IBlockState state) {
        SlabComponent sc = IBlockComponent.getComponent(SlabComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        PropertyEnum property = sc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)property) == BlockSlab.EnumBlockHalf.TOP;
    }

    public static boolean isDoubleSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isDoubleSlab(world.func_180495_p(pos).func_177230_c());
    }

    public static boolean isDoubleSlab(Block block) {
        SlabComponent sc = IBlockComponent.getComponent(SlabComponent.class, block);
        return sc != null && sc.isDouble(block);
    }

    public static boolean isSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isSlab(world.func_180495_p(pos).func_177230_c());
    }

    public static boolean isSlab(Block block) {
        if (block == Blocks.field_150333_U || block == Blocks.field_150376_bx || block == Blocks.field_180389_cP) {
            return true;
        }
        return IBlockComponent.getComponent(SlabComponent.class, block) != null;
    }
}

