/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LadderComponent
implements IBlockComponent {
    @Override
    public IProperty getProperty() {
        return null;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state;
    }

    @Override
    public List<IBlockComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IBlockComponent[]{new DirectionalComponent(DirectionalComponent.Placement.BLOCKSIDE)});
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    @Override
    public void onNeighborBlockChange(Block block, World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing dir = DirectionalComponent.getDirection((IBlockAccess)world, pos);
        if (!this.canBlockStay(world, pos, dir)) {
            block.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    }

    @Override
    public boolean canPlaceBlockOnSide(Block block, World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    @Override
    public boolean canPlaceBlockAt(Block block, World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST, true) || world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST, true) || world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH, true) || world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH, true);
    }

    @Override
    public Boolean isOpaqueCube(Block block) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block) {
        return false;
    }
}

