/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.List;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorComponent
implements IBlockComponent {
    public static PropertyEnum COLOR = BlockColored.field_176581_a;
    private boolean useColorMultiplier = true;

    public ColorComponent(boolean useColorMultiplier) {
        this.useColorMultiplier = useColorMultiplier;
    }

    public boolean useColorMultiplier() {
        return this.useColorMultiplier;
    }

    public PropertyEnum getProperty() {
        return COLOR;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)EnumDyeColor.WHITE);
    }

    @Override
    public String getUnlocalizedName(Block block, IBlockState state) {
        return block.func_149739_a() + "." + ColorComponent.getColor(state).func_176762_d();
    }

    @Override
    public Item getItem(Block block) {
        return new MalisisItemBlock(block);
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)this.getProperty())).func_176765_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Block block, Item item, CreativeTabs tab, List list) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            list.add(new ItemStack(item, 1, color.func_176765_a()));
        }
    }

    @Override
    public int colorMultiplier(Block block, IBlockAccess world, BlockPos pos, int renderPass) {
        if (!this.useColorMultiplier) {
            return 0xFFFFFF;
        }
        return this.getRenderColor(block, world.func_180495_p(pos));
    }

    @Override
    public int getRenderColor(Block block, IBlockState state) {
        return ItemDye.field_150922_c[ColorComponent.getColor(state).func_176767_b()];
    }

    @Override
    public MapColor getMapColor(Block block, IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)this.getProperty())).func_176768_e();
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b((IProperty)this.getProperty())).func_176765_a();
    }

    public static EnumDyeColor getColor(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? ColorComponent.getColor(world.func_180495_p(pos)) : EnumDyeColor.WHITE;
    }

    public static EnumDyeColor getColor(IBlockState state) {
        ColorComponent cc = IBlockComponent.getComponent(ColorComponent.class, state.func_177230_c());
        if (cc == null) {
            return EnumDyeColor.WHITE;
        }
        PropertyEnum property = cc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return EnumDyeColor.WHITE;
        }
        return (EnumDyeColor)state.func_177229_b((IProperty)property);
    }
}

