/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.component.LadderComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.IIconProvider;
import net.malisis.core.renderer.icon.IMetaIconProvider;
import net.malisis.core.renderer.icon.provider.DefaultIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(value=DefaultRenderer.Block.class)
public class MalisisBlock
extends Block
implements IBoundingBox,
IMetaIconProvider,
IRegisterable,
IComponentProvider {
    private static Field blockStateField = AsmUtils.changeFieldAccess(Block.class, "blockState", "field_176227_L");
    protected String name;
    protected AxisAlignedBB boundingBox;
    protected final List<IBlockComponent> components = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    protected IIconProvider iconProvider;

    protected MalisisBlock(Material material) {
        super(material);
    }

    protected List<IProperty> getProperties() {
        return Lists.newArrayList();
    }

    protected void buildBlockState() {
        List<IProperty> properties = this.getProperties();
        for (IBlockComponent component : this.getComponents()) {
            properties.addAll(Arrays.asList(component.getProperties()));
        }
        try {
            blockStateField.set(this, new BlockState((Block)this, properties.toArray(new IProperty[0])));
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("[MalisisBlock] Failed to set the new BlockState for {}.", new Object[]{this.getClass().getSimpleName(), e});
        }
    }

    private void buildDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b();
        for (IBlockComponent component : this.getComponents()) {
            state = component.setDefaultState(this, state);
        }
        this.func_180632_j(state);
    }

    @Override
    public List<IBlockComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IBlockComponent component) {
        this.components.add(component);
        for (IBlockComponent dep : component.getDependencies()) {
            this.components.add(dep);
        }
        this.buildBlockState();
        this.buildDefaultState();
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
    }

    @Override
    public <T> T getComponent(Class<T> type) {
        for (IBlockComponent component : this.components) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            return (T)component;
        }
        return null;
    }

    public Block setName(String name) {
        this.name = name;
        super.func_149663_c(name);
        return this;
    }

    public String getUnlocalizedName(IBlockState state) {
        for (IBlockComponent component : this.components) {
            String name = component.getUnlocalizedName(this, state);
            if (name == null) continue;
            return name;
        }
        return this.func_149739_a();
    }

    @Override
    public Item getItem(Block block) {
        for (IBlockComponent component : this.components) {
            Item item = component.getItem(this);
            if (item != null && item.getClass() == MalisisItemBlock.class) continue;
            return item;
        }
        return IRegisterable.super.getItem(this);
    }

    @Override
    public String getRegistryName() {
        return this.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createIconProvider(Object object) {
        if (object != null) {
            this.iconProvider = DefaultIconProvider.from(object);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public IBlockState getStateFromItemStack(ItemStack itemStack) {
        return this.func_176203_a(itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        for (IBlockComponent component : this.getComponents()) {
            state = component.onBlockPlaced(this, world, pos, state, facing, hitX, hitY, hitZ, meta, placer);
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        for (IBlockComponent component : this.getComponents()) {
            component.onBlockPlacedBy(this, world, pos, state, placer, stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b = false;
        for (IBlockComponent component : this.getComponents()) {
            b |= component.onBlockActivated(this, world, pos, state, player, side, hitX, hitY, hitZ);
        }
        return b;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        for (IBlockComponent component : this.getComponents()) {
            component.onNeighborBlockChange(this, world, pos, state, neighborBlock);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            component.breakBlock(this, world, pos, state);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        for (IBlockComponent component : this.getComponents()) {
            AxisAlignedBB aabb = component.getBoundingBox(this, world, pos, type);
            if (aabb == null) continue;
            return aabb;
        }
        return new AxisAlignedBB(this.field_149759_B, this.field_149760_C, this.field_149754_D, this.field_149755_E, this.field_149756_F, this.field_149757_G);
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        ArrayList list = Lists.newArrayList();
        for (IBlockComponent component : this.getComponents()) {
            AxisAlignedBB[] aabbs = component.getBoundingBoxes(this, world, pos, type);
            if (aabbs == null) continue;
            list.addAll(Arrays.asList(aabbs));
        }
        return list.size() != 0 ? list.toArray(new AxisAlignedBB[0]) : IBoundingBox.super.getBoundingBoxes(world, pos, type);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        IBoundingBox.super.addCollisionBoxesToList(world, pos, state, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return IBoundingBox.super.getSelectedBoundingBox(world, pos);
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 src, Vec3 dest) {
        return IBoundingBox.super.collisionRayTrace(world, pos, src, dest);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getComponents()) {
            if (component.canPlaceBlockOnSide(this, world, pos, side)) continue;
            return false;
        }
        return super.func_176198_a(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            if (component.canPlaceBlockAt(this, world, pos)) continue;
            return false;
        }
        return super.func_176196_c(world, pos);
    }

    public int func_180651_a(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            int damage = component.damageDropped(this, state);
            if (damage == 0) continue;
            return damage;
        }
        return super.func_180651_a(state);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        ArrayList l = Lists.newArrayList();
        for (IBlockComponent component : this.getComponents()) {
            component.getSubBlocks(this, item, tab, l);
        }
        if (l.isEmpty()) {
            super.func_149666_a(item, tab, list);
        } else {
            list.addAll(l);
        }
    }

    public int func_180662_a(IBlockAccess world, BlockPos pos, int renderPass) {
        for (IBlockComponent component : this.components) {
            int color = component.colorMultiplier(this, world, pos, renderPass);
            if (color == 0xFFFFFF) continue;
            return color;
        }
        return super.func_180662_a(world, pos, renderPass);
    }

    public MapColor func_180659_g(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            MapColor color = component.getMapColor(this, state);
            if (color == null) continue;
            return color;
        }
        return super.func_180659_g(state);
    }

    public int func_180644_h(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            int color = component.getRenderColor(this, state);
            if (color == 0xFFFFFF) continue;
            return color;
        }
        return super.func_180644_h(state);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        for (IBlockComponent component : this.getComponents()) {
            state = component.getStateFromMeta(this, state, meta);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        for (IBlockComponent component : this.getComponents()) {
            meta += component.getMetaFromState(this, state);
        }
        return meta;
    }

    public boolean func_176225_a(IBlockAccess world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getComponents()) {
            Boolean render = component.shouldSideBeRendered(this, world, pos, side);
            if (render == null) continue;
            return render;
        }
        return super.func_176225_a(world, pos, side);
    }

    public boolean func_149730_j() {
        for (IBlockComponent component : this.getComponents()) {
            Boolean full = component.isFullCube(this);
            if (full == null) continue;
            return full;
        }
        return super.func_149686_d();
    }

    public boolean func_149686_d() {
        for (IBlockComponent component : this.getComponents()) {
            Boolean full = component.isFullCube(this);
            if (full == null) continue;
            return full;
        }
        return super.func_149686_d();
    }

    public boolean func_149662_c() {
        if (this.getComponents() == null) {
            return super.func_149662_c();
        }
        for (IBlockComponent component : this.getComponents()) {
            Boolean opaque = component.isOpaqueCube(this);
            if (opaque == null) continue;
            return opaque;
        }
        return super.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_176207_c(IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            Integer light = component.getMixedBrightnessForBlock(this, world, pos);
            if (light == null) continue;
            return light;
        }
        return super.func_176207_c(world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        for (IBlockComponent component : this.getComponents()) {
            Item item = component.getItemDropped(this, state, rand, fortune);
            if (item == null) continue;
            return item;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        for (IBlockComponent component : this.getComponents()) {
            Integer quantity = component.quantityDropped(this, state, fortune, random);
            if (quantity == null) continue;
            return quantity;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            Integer quantity = component.getLightOpacity(this, world, pos);
            if (quantity == null) continue;
            return quantity;
        }
        return super.getLightOpacity(world, pos);
    }

    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return IBlockComponent.getComponent(LadderComponent.class, this) != null;
    }

    public int func_149645_b() {
        return 4;
    }
}

