/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public interface IBoundingBox {
    public AxisAlignedBB getBoundingBox(IBlockAccess var1, BlockPos var2, BoundingBoxType var3);

    default public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        return new AxisAlignedBB[]{this.getBoundingBox(world, pos, type)};
    }

    default public AxisAlignedBB[] getCollisionBoundingBoxes(World world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, BoundingBoxType.COLLISION);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public void addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, BoundingBoxType.COLLISION);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        for (AxisAlignedBB aabb : AABBUtils.offset(pos, aabbs)) {
            if (aabb == null || !mask.func_72326_a(aabb)) continue;
            list.add(aabb);
        }
    }

    default public AxisAlignedBB getSelectedBoundingBox(World world, BlockPos pos) {
        Object[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AABBUtils.empty(pos);
        }
        aabbs = AABBUtils.rotate((AxisAlignedBB[])aabbs, DirectionalComponent.getDirection((IBlockAccess)world, pos));
        return AABBUtils.offset(pos, AABBUtils.combine((AxisAlignedBB[])aabbs));
    }

    default public AxisAlignedBB[] getRenderBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes(world, pos, BoundingBoxType.RENDER);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public AxisAlignedBB[] getRayTraceBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes(world, pos, BoundingBoxType.RAYTRACE);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public MovingObjectPosition collisionRayTrace(World world, BlockPos pos, Vec3 src, Vec3 dest) {
        return new RaytraceBlock(world, src, dest, pos).trace();
    }
}

