/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.item.MalisisItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBlockComponent {
    public IProperty getProperty();

    default public IProperty[] getProperties() {
        if (this.getProperty() == null) {
            return new IProperty[0];
        }
        return new IProperty[]{this.getProperty()};
    }

    public IBlockState setDefaultState(Block var1, IBlockState var2);

    default public Item getItem(Block block) {
        return new MalisisItemBlock(block);
    }

    default public List<IBlockComponent> getDependencies() {
        return ImmutableList.of();
    }

    default public String getUnlocalizedName(Block block, IBlockState state) {
        return null;
    }

    default public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return state;
    }

    default public void onBlockPlacedBy(Block block, World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    default public boolean onBlockActivated(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    default public void onNeighborBlockChange(Block block, World world, BlockPos pos, IBlockState state, Block neighborBlock) {
    }

    default public void breakBlock(Block block, World world, BlockPos pos, IBlockState state) {
    }

    default public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        return null;
    }

    default public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        return null;
    }

    default public boolean canPlaceBlockOnSide(Block block, World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    default public boolean canPlaceBlockAt(Block block, World world, BlockPos pos) {
        return true;
    }

    default public int damageDropped(Block block, IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    default public void getSubBlocks(Block block, Item item, CreativeTabs tab, List list) {
    }

    default public int colorMultiplier(Block block, IBlockAccess world, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    default public int getRenderColor(Block block, IBlockState state) {
        return 0xFFFFFF;
    }

    default public MapColor getMapColor(Block block, IBlockState state) {
        return null;
    }

    default public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state;
    }

    default public int getMetaFromState(Block block, IBlockState state) {
        return 0;
    }

    default public Boolean shouldSideBeRendered(Block block, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return null;
    }

    default public Boolean isFullBlock(Block block) {
        return null;
    }

    default public Boolean isFullCube(Block block) {
        return null;
    }

    default public Boolean isOpaqueCube(Block block) {
        return null;
    }

    default public Integer getMixedBrightnessForBlock(Block block, IBlockAccess world, BlockPos pos) {
        return null;
    }

    default public Item getItemDropped(Block block, IBlockState state, Random rand, int fortune) {
        return null;
    }

    default public Integer quantityDropped(Block block, IBlockState state, int fortune, Random random) {
        return null;
    }

    default public Integer getLightOpacity(Block block, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public static <T> T getComponent(Class<T> type, Block block) {
        if (block.getClass().isAssignableFrom(type)) {
            return (T)block;
        }
        if (!(block instanceof IComponentProvider)) {
            return null;
        }
        return ((IComponentProvider)block).getComponent(type);
    }

    public static IProperty getProperty(Class<?> type, Block block) {
        Object component = IBlockComponent.getComponent(type, block);
        if (component instanceof IBlockComponent) {
            return ((IBlockComponent)component).getProperty();
        }
        return null;
    }
}

