/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.replacement;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.util.replacement.ReplacementHandler;
import net.malisis.core.util.replacement.ShapedOreRecipeHandler;
import net.malisis.core.util.replacement.ShapedRecipesHandler;
import net.malisis.core.util.replacement.ShapelessOreRecipeHandler;
import net.malisis.core.util.replacement.ShapelessRecipesHandler;
import net.malisis.core.util.replacement.StatCraftingHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public class ReplacementTool {
    private static ReplacementTool instance = new ReplacementTool();
    private HashMap<Block, Block> originalBlocks = new HashMap();
    private HashMap<Item, Item> originalItems = new HashMap();
    private Class[] types = new Class[]{Integer.TYPE, Object.class, Object.class};
    private Method addObjectRaw = AsmUtils.changeMethodAccess(FMLControlledNamespacedRegistry.class, "addObjectRaw", this.types);
    private Method setName = AsmUtils.changeMethodAccess(RegistryDelegate.Delegate.class, "setName", String.class);

    private ReplacementTool() {
        new ShapedOreRecipeHandler();
        new ShapedRecipesHandler();
        new ShapelessRecipesHandler();
        new ShapelessOreRecipeHandler();
        new StatCraftingHandler();
    }

    public static ReplacementTool instance() {
        return instance;
    }

    private void replaceVanilla(int id, String registryName, String fieldName, String srgFieldName, Object replacement, Object vanilla) {
        boolean block = replacement instanceof Block;
        RegistryNamespacedDefaultedByKey registry = block ? Block.blockRegistry : Item.itemRegistry;
        ItemBlock ib = block ? (ItemBlock)Item.getItemFromBlock((Block)((Block)vanilla)) : null;
        Class clazz = block ? Blocks.class : Items.class;
        HashMap<Block, Block> map = block ? this.originalBlocks : this.originalItems;
        try {
            this.setName.invoke((Object)(block ? ((Block)replacement).delegate : ((Item)replacement).delegate), registryName);
            this.addObjectRaw.invoke((Object)registry, id, new ResourceLocation("minecraft", registryName), replacement);
            Field f = AsmUtils.changeFieldAccess(clazz, fieldName, srgFieldName);
            f.set(null, replacement);
            if (ib != null) {
                AsmUtils.changeFieldAccess(ItemBlock.class, "block", "field_150939_a").set(ib, replacement);
                GameData.getBlockItemMap().put(replacement, ib);
            }
            map.put((Block)replacement, (Block)vanilla);
            this.replaceIn(CraftingManager.getInstance().getRecipeList(), vanilla, replacement);
            this.replaceIn(StatList.allStats, vanilla, replacement);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void replaceIn(List<?> list, Object vanilla, Object replacement) throws ReflectiveOperationException {
        for (Object object : list) {
            ReplacementHandler rh = ReplacementHandler.getHandler(object);
            if (rh == null) continue;
            rh.replace(object, vanilla, replacement);
        }
    }

    public static void replaceVanillaBlock(int id, String registryName, String fieldName, String srgFieldName, Block replacement, Block vanilla) {
        ReplacementTool.instance().replaceVanilla(id, registryName, fieldName, srgFieldName, replacement, vanilla);
    }

    public static void replaceVanillaItem(int id, String registryName, String fieldName, String srgFieldName, Item replacement, Item vanilla) {
        ReplacementTool.instance().replaceVanilla(id, registryName, fieldName, srgFieldName, replacement, vanilla);
    }

    public static Block orignalBlock(Block block) {
        return ReplacementTool.instance.originalBlocks.get(block);
    }

    public static Item originalItem(Item item) {
        return ReplacementTool.instance.originalItems.get(item);
    }
}

