/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.remapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;

public class RemappingTool {
    private static RemappingTool instance = new RemappingTool();
    private Set<ModContainer> mods = new HashSet<ModContainer>();
    private Map<String, Block> blocks = new HashMap<String, Block>();
    private Map<String, Item> items = new HashMap<String, Item>();

    private ModContainer getContainer(String name) {
        ModContainer mod = null;
        int index = name.indexOf(":");
        if (index == -1) {
            MalisisCore.log.warn("[RemappingTool] No mod ID found for {}, using current active container.", new Object[]{name});
            return Loader.instance().activeModContainer();
        }
        String modid = name.substring(0, index);
        mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (mod == null) {
            MalisisCore.log.warn("[RemappingTool] No mod found for {}, using dummy container.", new Object[]{name});
            ModMetadata md = new ModMetadata();
            md.modId = modid;
            return new DummyModContainer(md);
        }
        return mod;
    }

    public static void remap(String old, Block block) {
        RemappingTool.instance.mods.add(instance.getContainer(old));
        RemappingTool.instance.blocks.put(old, block);
        Item item = Item.getItemFromBlock((Block)block);
        if (item instanceof ItemBlock) {
            RemappingTool.remap(old, item);
        }
    }

    public static void remap(String old, Item item) {
        RemappingTool.instance.mods.add(instance.getContainer(old));
        RemappingTool.instance.items.put(old, item);
    }

    public static void processMissingMappings(FMLMissingMappingsEvent event) {
        instance.processMappings(event.getAll());
    }

    private void processMappings(List<FMLMissingMappingsEvent.MissingMapping> mappings) {
        for (FMLMissingMappingsEvent.MissingMapping missingMapping : mappings) {
            if (!MalisisCore.isObfEnv) {
                missingMapping.ignore();
                continue;
            }
            switch (missingMapping.type) {
                case BLOCK: {
                    if (!RemappingTool.instance.blocks.containsKey(missingMapping.name)) break;
                    MalisisCore.log.info("Remapping {} to {}", new Object[]{missingMapping.name, RemappingTool.instance.blocks.get(missingMapping.name)});
                    missingMapping.remap(RemappingTool.instance.blocks.get(missingMapping.name));
                    break;
                }
                case ITEM: {
                    if (!RemappingTool.instance.items.containsKey(missingMapping.name)) break;
                    missingMapping.remap(RemappingTool.instance.items.get(missingMapping.name));
                    MalisisCore.log.info("Remapping {} to {}", new Object[]{missingMapping.name, RemappingTool.instance.items.get(missingMapping.name)});
                }
            }
        }
    }

    public static RemappingTool instance() {
        return instance;
    }
}

