/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.multiblock.MultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class PatternMultiBlock
extends MultiBlock {
    private List<List<String>> pattern = new LinkedList<List<String>>();
    private Map<Character, MBlockState> blocks = new HashMap<Character, MBlockState>();

    public PatternMultiBlock addLayer(String ... layer) {
        this.pattern.add(Arrays.asList(layer));
        this.buildStates();
        return this;
    }

    public PatternMultiBlock withRef(char c, Block block) {
        return this.withRef(c, block.getDefaultState());
    }

    public PatternMultiBlock withRef(char c, IBlockState state) {
        return this.withRef(c, new MBlockState(state));
    }

    public PatternMultiBlock withRef(char c, MBlockState state) {
        this.blocks.put(Character.valueOf(c), state);
        this.buildStates();
        return this;
    }

    @Override
    public void buildStates() {
        this.states.clear();
        for (int y = 0; y < this.pattern.size(); ++y) {
            List<String> layer = this.pattern.get(y);
            for (int z = 0; z < layer.size(); ++z) {
                String row = layer.get(z);
                for (int x = 0; x < row.length(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z).add((Vec3i)this.offset);
                    MBlockState state = this.blocks.get(Character.valueOf(row.charAt(x)));
                    if (state == null) continue;
                    this.states.put(pos, new MBlockState(pos, state));
                }
            }
        }
    }
}

