/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import net.malisis.core.util.MBlockState;
import net.malisis.core.util.multiblock.MultiBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;

public class MultiBlockAccess
implements IBlockAccess {
    private MultiBlock multiBlock;
    private IBlockAccess world;

    public MultiBlockAccess(MultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    public MultiBlockAccess(MultiBlock multiBlock, IBlockAccess world) {
        this.multiBlock = multiBlock;
        this.world = world;
    }

    public TileEntity getTileEntity(BlockPos pos) {
        return null;
    }

    public int getCombinedLight(BlockPos pos, int lightValue) {
        return 0xF000F0;
    }

    public IBlockState getBlockState(BlockPos pos) {
        MBlockState state = this.multiBlock.getState(pos);
        if (state != null) {
            return state.getBlockState();
        }
        return this.world != null ? this.world.getBlockState(pos) : Blocks.air.getDefaultState();
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.getBlockState(pos).getBlock().isAir((IBlockAccess)this, pos);
    }

    public BiomeGenBase getBiomeGenForCoords(BlockPos pos) {
        return null;
    }

    public boolean extendedLevelsInChunkCache() {
        return false;
    }

    public int getStrongPower(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    public WorldType getWorldType() {
        return null;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.getBlockState(pos).getBlock().isSideSolid((IBlockAccess)this, pos, side);
    }
}

