/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class AABBMultiBlock
extends MultiBlock {
    private AxisAlignedBB aabb;
    private IBlockState blockState;

    public AABBMultiBlock(Block block, AxisAlignedBB aabb) {
        this.aabb = aabb;
        this.blockState = block.getDefaultState();
        this.buildStates();
    }

    public AxisAlignedBB getBoundingBox() {
        return this.aabb;
    }

    public AxisAlignedBB getRelativeBoundingBox(BlockPos pos, BlockPos origin) {
        pos = pos.subtract((Vec3i)origin);
        return this.aabb.offset((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
    }

    @Override
    protected void buildStates() {
        this.states.clear();
        for (BlockPos pos : BlockPosUtils.getAllInBox(this.aabb)) {
            if (this.offset != null) {
                pos = pos.add((Vec3i)this.offset);
            }
            this.states.put(pos, new MBlockState(pos, this.blockState));
        }
    }

    @Override
    public void placeBlocks(World world, BlockPos pos, IBlockState state, boolean placeOrigin) {
        DirectionalComponent dc = IBlockComponent.getComponent(DirectionalComponent.class, state.getBlock());
        MultiBlockComponent mbc = IBlockComponent.getComponent(MultiBlockComponent.class, state.getBlock());
        this.blockState = state.withProperty((IProperty)mbc.getProperty(), (Comparable)Boolean.valueOf(false)).withProperty((IProperty)dc.getProperty(), (Comparable)EnumFacing.SOUTH);
        this.buildStates();
        super.placeBlocks(world, pos, state, placeOrigin);
    }
}

