/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkcollision;

import java.util.List;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.Point;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.ArrayUtils;

public class ChunkCollision {
    private static ChunkCollision instance = new ChunkCollision();
    private Point src;
    private Point dest;

    public void getCollisionBoundingBoxes(World world, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        CollisionProcedure procedure = new CollisionProcedure(mask, list);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, mask)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
    }

    public void setRayTraceInfos(Vec3 src, Vec3 dest) {
        if (src == null || dest == null) {
            return;
        }
        this.setRayTraceInfos(new Point(src), new Point(dest));
    }

    public void setRayTraceInfos(Point src, Point dest) {
        this.src = src;
        this.dest = dest;
    }

    public MovingObjectPosition getRayTraceResult(World world, MovingObjectPosition mop) {
        if (this.src == null || this.dest == null) {
            return mop;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.y, this.dest.z);
        RayTraceProcedure procedure = new RayTraceProcedure(this.src, this.dest, mop);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, aabb)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
        return procedure.mop;
    }

    private MovingObjectPosition getClosest(Point src, MovingObjectPosition mop1, MovingObjectPosition mop2) {
        if (mop1 == null) {
            return mop2;
        }
        if (mop2 == null) {
            return mop1;
        }
        if (mop1.typeOfHit == MovingObjectPosition.MovingObjectType.MISS && mop2.typeOfHit != MovingObjectPosition.MovingObjectType.MISS) {
            return mop2;
        }
        if (mop1.typeOfHit != MovingObjectPosition.MovingObjectType.MISS && mop2.typeOfHit == MovingObjectPosition.MovingObjectType.MISS) {
            return mop1;
        }
        Point point = new Point(mop1.hitVec);
        Point point2 = new Point(mop2.hitVec);
        if (Point.distanceSquared(src, point) > Point.distanceSquared(src, point2)) {
            return mop2;
        }
        return mop1;
    }

    public boolean canPlaceBlockAt(ItemStack itemStack, EntityPlayer player, World world, Block block, BlockPos pos, EnumFacing side) {
        Object[] aabbs = block instanceof IChunkCollidable ? ((IChunkCollidable)block).getPlacedBoundingBox((IBlockAccess)world, pos, side, player, itemStack) : AABBUtils.getCollisionBoundingBoxes(world, block, pos);
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return true;
        }
        AABBUtils.offset(pos, (AxisAlignedBB[])aabbs);
        if (block instanceof IChunkCollidable) {
            for (Object aabb : aabbs) {
                if (aabb == null) continue;
                for (BlockPos p : BlockPosUtils.getAllInBox((AxisAlignedBB)aabb)) {
                    boolean b = false;
                    b |= !world.getBlockState(p).getBlock().isReplaceable(world, p);
                    if (!(b &= AABBUtils.isColliding((AxisAlignedBB)aabb, AABBUtils.getCollisionBoundingBoxes(world, new MBlockState((IBlockAccess)world, p), true)))) continue;
                    return false;
                }
            }
        }
        CheckCollisionProcedure procedure = new CheckCollisionProcedure((AxisAlignedBB[])aabbs);
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, (AxisAlignedBB[])aabbs)) {
            ChunkBlockHandler.get().callProcedure(chunk, procedure);
        }
        return !procedure.collide;
    }

    public void replaceBlocks(World world, MBlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            if (aabb == null) continue;
            for (BlockPos pos : BlockPosUtils.getAllInBox(aabb)) {
                if (!world.getBlockState(pos).getBlock().isReplaceable(world, pos)) continue;
                world.setBlockToAir(pos);
            }
        }
    }

    public void updateBlocks(World world, MBlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            if (aabb == null) continue;
            for (BlockPos pos : BlockPosUtils.getAllInBox(aabb)) {
                world.notifyBlockOfStateChange(pos, state.getBlock());
            }
        }
    }

    public static ChunkCollision get() {
        return instance;
    }

    private static class CheckCollisionProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private AxisAlignedBB[] aabbs;
        private boolean collide = false;

        public CheckCollisionProcedure(AxisAlignedBB[] aabbs) {
            this.aabbs = aabbs;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            AxisAlignedBB[] blockBounds = AABBUtils.getCollisionBoundingBoxes(this.world, this.state);
            AABBUtils.offset(this.state.getX(), this.state.getY(), this.state.getZ(), blockBounds);
            this.collide = AABBUtils.isColliding(this.aabbs, blockBounds);
            return !this.collide;
        }

        @Override
        protected void clean() {
            super.clean();
            this.aabbs = null;
            this.collide = false;
        }
    }

    private static class RayTraceProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private Point src;
        private Point dest;
        private MovingObjectPosition mop;

        public RayTraceProcedure(Point src, Point dest, MovingObjectPosition mop) {
            this.src = src;
            this.dest = dest;
            this.mop = mop;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            RaytraceBlock rt = new RaytraceBlock(this.world, this.src, this.dest, this.state.getPos());
            this.mop = ChunkCollision.get().getClosest(this.src, rt.trace(), this.mop);
            return true;
        }

        @Override
        protected void clean() {
            super.clean();
            this.src = null;
            this.dest = null;
            this.mop = null;
        }
    }

    private static class CollisionProcedure
    extends ChunkBlockHandler.ChunkProcedure {
        private AxisAlignedBB mask;
        private List<AxisAlignedBB> list;

        public CollisionProcedure(AxisAlignedBB mask, List<AxisAlignedBB> list) {
            this.mask = mask;
            this.list = list;
        }

        public boolean execute(long coord) {
            if (!this.check(coord)) {
                return true;
            }
            if (this.state.getBlock() instanceof IChunkCollidable) {
                AxisAlignedBB[] aabbs;
                for (AxisAlignedBB aabb : aabbs = ((IChunkCollidable)this.state.getBlock()).getCollisionBoundingBoxes(this.world, this.state.getPos(), this.state.getBlockState())) {
                    if (this.mask == null || aabb == null || !this.mask.intersectsWith(aabb = AABBUtils.offset(this.state.getPos(), aabb))) continue;
                    this.list.add(aabb);
                }
            }
            return true;
        }

        @Override
        protected void clean() {
            super.clean();
            this.mask = null;
            this.list = null;
        }
    }
}

