/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class ChunkBlockMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public ChunkBlockMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        ChunkBlockHandler.get().setCoords(message.x, message.z, message.coords);
    }

    public static void sendCoords(Chunk chunk, long[] coords, EntityPlayerMP player) {
        MalisisCore.network.sendTo(new Packet(chunk, coords), player);
    }

    public static class Packet
    implements IMessage {
        private int x;
        private int z;
        private long[] coords;

        public Packet() {
        }

        public Packet(Chunk chunk, long[] coords) {
            this.x = chunk.xPosition;
            this.z = chunk.zPosition;
            this.coords = coords;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.z = buf.readInt();
            this.coords = new long[buf.readInt()];
            for (int i = 0; i < this.coords.length; ++i) {
                this.coords[i] = buf.readLong();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.z);
            buf.writeInt(this.coords.length);
            for (long c : this.coords) {
                buf.writeLong(c);
            }
        }
    }
}

