/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.chunkblock.ChunkBlockMessage;
import net.malisis.core.util.chunkblock.IChunkBlock;
import net.malisis.core.util.chunkblock.IChunkBlockHandler;
import net.malisis.core.util.chunklistener.ChunkListener;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChunkBlockHandler
implements IChunkBlockHandler {
    private static ChunkBlockHandler instance = new ChunkBlockHandler();
    private Map<Chunk, TLongHashSet> serverChunks = new WeakHashMap<Chunk, TLongHashSet>();
    private Map<Chunk, TLongHashSet> clientChunks = new WeakHashMap<Chunk, TLongHashSet>();
    private List<IChunkBlockHandler> handlers = new ArrayList<IChunkBlockHandler>();

    public ChunkBlockHandler() {
        this.handlers.add(new ChunkListener());
    }

    private TLongHashSet getCoords(Chunk chunk) {
        Map<Chunk, TLongHashSet> chunks = chunk.getWorld().isRemote ? this.clientChunks : this.serverChunks;
        TLongHashSet coords = chunks.get(chunk);
        if (coords == null) {
            coords = new TLongHashSet();
            chunks.put(chunk, coords);
        }
        return coords;
    }

    public void callProcedure(Chunk chunk, ChunkProcedure procedure) {
        procedure.set(chunk);
        TLongHashSet coords = this.getCoords(chunk);
        if (coords != null) {
            coords.forEach((TLongProcedure)procedure);
        }
    }

    public void addHandler(IChunkBlockHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public boolean updateCoordinates(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean canceled = false;
        for (IChunkBlockHandler handler : this.handlers) {
            canceled |= handler.updateCoordinates(chunk, pos, oldState, newState);
        }
        if (!canceled) {
            if (oldState.getBlock() instanceof IChunkBlock) {
                this.removeCoord(chunk.getWorld(), pos, ((IChunkBlock)oldState.getBlock()).blockRange());
            }
            if (newState.getBlock() instanceof IChunkBlock) {
                this.addCoord(chunk.getWorld(), pos, ((IChunkBlock)newState.getBlock()).blockRange());
            }
        }
        return !canceled;
    }

    private void addCoord(World world, BlockPos pos, int size) {
        List<Chunk> affectedChunks = this.getAffectedChunks(world, pos.getX(), pos.getZ(), size);
        for (Chunk chunk : affectedChunks) {
            this.addCoord(chunk, pos);
        }
    }

    private void addCoord(Chunk chunk, BlockPos pos) {
        this.getCoords(chunk).add(pos.toLong());
    }

    private void removeCoord(World world, BlockPos pos, int size) {
        List<Chunk> affectedChunks = this.getAffectedChunks(world, pos.getX(), pos.getZ(), size);
        for (Chunk chunk : affectedChunks) {
            this.removeCoord(chunk, pos);
        }
    }

    private void removeCoord(Chunk chunk, BlockPos pos) {
        if (!this.getCoords(chunk).remove(pos.toLong())) {
            MalisisCore.log.error("Failed to remove : {} ({})", new Object[]{pos, pos.toLong()});
        }
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt = event.getData();
        if (!nbt.hasKey("chunkNotifier")) {
            return;
        }
        long[] coords = this.readLongArray(nbt);
        Map<Chunk, TLongHashSet> chunks = event.getChunk().getWorld().isRemote ? this.clientChunks : this.serverChunks;
        chunks.put(event.getChunk(), new TLongHashSet(coords));
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        TLongHashSet coords = this.getCoords(event.getChunk());
        if (coords == null || coords.size() == 0) {
            return;
        }
        NBTTagCompound nbt = event.getData();
        this.writeLongArray(nbt, coords.toArray());
    }

    private long[] readLongArray(NBTTagCompound compound) {
        ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.getByteArray("chunkNotifier"));
        long[] longs = new long[bytes.capacity() / 8];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = bytes.readLong();
        }
        return longs;
    }

    private void writeLongArray(NBTTagCompound compound, long[] longs) {
        ByteBuf bytes = Unpooled.buffer((int)(longs.length * 8));
        for (long aLong : longs) {
            bytes.writeLong(aLong);
        }
        compound.setByteArray("chunkNotifier", bytes.array());
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.player.worldObj.getChunkFromChunkCoords(event.chunk.chunkXPos, event.chunk.chunkZPos);
        TLongHashSet coords = this.getCoords(chunk);
        if (coords == null || coords.size() == 0) {
            return;
        }
        ChunkBlockMessage.sendCoords(chunk, coords.toArray(), event.player);
    }

    public void setCoords(int chunkX, int chunkZ, long[] coords) {
        Chunk chunk = Minecraft.getMinecraft().theWorld.getChunkFromChunkCoords(chunkX, chunkZ);
        Map<Chunk, TLongHashSet> chunks = chunk.getWorld().isRemote ? this.clientChunks : this.serverChunks;
        chunks.put(chunk, new TLongHashSet(coords));
    }

    public List<Chunk> getAffectedChunks(World world, int x, int z, int distance) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)(x - distance), 0.0, (double)(z - distance), (double)(x + distance + 1), 1.0, (double)(z + distance + 1));
        return ChunkBlockHandler.getAffectedChunks(world, aabb);
    }

    public static List<Chunk> getAffectedChunks(World world, AxisAlignedBB ... aabbs) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            for (int cx = (int)Math.floor(aabb.minX) >> 4; cx <= (int)Math.ceil(aabb.maxX) >> 4; ++cx) {
                for (int cz = (int)Math.floor(aabb.minZ) >> 4; cz <= (int)Math.ceil(aabb.maxZ) >> 4; ++cz) {
                    if (world.getChunkProvider() == null || !world.getChunkProvider().chunkExists(cx, cz)) continue;
                    chunks.add(world.getChunkFromChunkCoords(cx, cz));
                }
            }
        }
        return chunks;
    }

    public static ChunkBlockHandler get() {
        return instance;
    }

    public static abstract class ChunkProcedure
    implements TLongProcedure {
        protected World world;
        protected Chunk chunk;
        protected MBlockState state;

        protected void set(Chunk chunk) {
            this.world = chunk.getWorld();
            this.chunk = chunk;
        }

        protected boolean check(long coord) {
            this.state = new MBlockState((IBlockAccess)this.world, coord);
            if (!(this.state.getBlock() instanceof IChunkBlock)) {
                MalisisCore.log.info("[ChunkNotificationHandler]  Removing invalid {} coordinate : {} in chunk {},{}", new Object[]{this.world.isRemote ? "client" : "server", this.state, this.chunk.xPosition, this.chunk.zPosition});
                ChunkBlockHandler.get().removeCoord(this.chunk, this.state.getPos());
                return false;
            }
            return true;
        }

        protected void clean() {
            this.world = null;
            this.chunk = null;
            this.state = null;
        }
    }
}

