/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.blockdata;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.blockdata.BlockDataMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockDataHandler {
    private static BlockDataHandler instance = new BlockDataHandler();
    private static Field worldField = AsmUtils.changeFieldAccess(ChunkCache.class, "worldObj", "field_72815_e");
    private Map<String, HandlerInfo> handlerInfos = new HashMap<String, HandlerInfo>();
    private Table<String, Chunk, ChunkData<?>> serverDatas = HashBasedTable.create();
    private Table<String, Chunk, ChunkData<?>> clientDatas = HashBasedTable.create();

    private Table<String, Chunk, ChunkData<?>> data(World world) {
        return this.world((IBlockAccess)world).isRemote ? BlockDataHandler.instance.clientDatas : BlockDataHandler.instance.serverDatas;
    }

    private World world(IBlockAccess world) {
        if (world instanceof World) {
            return (World)world;
        }
        if (world instanceof ChunkCache) {
            return Silenced.get(() -> (World)worldField.get(world));
        }
        return null;
    }

    private ChunkData<?> chunkData(String identifier, World world, BlockPos pos) {
        return this.chunkData(identifier, world, world.getChunkFromBlockCoords(pos));
    }

    private ChunkData<?> chunkData(String identifier, World world, Chunk chunk) {
        ChunkData chunkData = (ChunkData)instance.data(world).get((Object)identifier, (Object)chunk);
        if (chunkData == null) {
            chunkData = new ChunkData(this.handlerInfos.get(identifier));
            instance.data(world).put((Object)identifier, (Object)chunk, chunkData);
        }
        return chunkData;
    }

    public static <T> void registerBlockData(String identifier, Function<ByteBuf, T> from, Function<T, ByteBuf> to) {
        BlockDataHandler.instance.handlerInfos.put(identifier, new HandlerInfo<T>(identifier, from, to));
    }

    public static <T> T getData(String identifier, IBlockAccess world, BlockPos pos) {
        return (T)instance.chunkData(identifier, instance.world(world), pos).getData(pos);
    }

    public static <T> void setData(String identifier, IBlockAccess world, BlockPos pos, T data) {
        instance.chunkData(identifier, instance.world(world), pos).setData(pos, data);
    }

    public static <T> void removeData(String identifier, IBlockAccess world, BlockPos pos) {
        BlockDataHandler.setData(identifier, world, pos, null);
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo handlerInfo : this.handlerInfos.values()) {
            if (!nbt.hasKey(handlerInfo.identifier)) continue;
            ChunkData chunkData = new ChunkData(handlerInfo);
            chunkData.fromBytes(Unpooled.copiedBuffer((byte[])nbt.getByteArray(handlerInfo.identifier)));
            this.data(event.world).put((Object)handlerInfo.identifier, (Object)event.getChunk(), chunkData);
        }
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo handlerInfo : this.handlerInfos.values()) {
            ChunkData<?> chunkData = this.chunkData(handlerInfo.identifier, event.world, event.getChunk());
            if (!chunkData.hasData()) continue;
            ByteBuf buf = Unpooled.buffer();
            chunkData.toBytes(buf);
            nbt.setByteArray(handlerInfo.identifier, buf.capacity(buf.writerIndex()).array());
        }
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.player.worldObj.getChunkFromChunkCoords(event.chunk.chunkXPos, event.chunk.chunkZPos);
        for (HandlerInfo handlerInfo : this.handlerInfos.values()) {
            ChunkData<?> chunkData = instance.chunkData(handlerInfo.identifier, chunk.getWorld(), chunk);
            if (!chunkData.hasData()) continue;
            BlockDataMessage.sendBlockData(chunk, handlerInfo.identifier, chunkData.toBytes(Unpooled.buffer()), event.player);
        }
    }

    static void setBlockData(int chunkX, int chunkZ, String identifier, ByteBuf data) {
        HandlerInfo handlerInfo = BlockDataHandler.instance.handlerInfos.get(identifier);
        if (handlerInfo == null) {
            return;
        }
        Chunk chunk = Minecraft.getMinecraft().theWorld.getChunkFromChunkCoords(chunkX, chunkZ);
        ChunkData chunkData = new ChunkData(handlerInfo).fromBytes(data);
        instance.data(chunk.getWorld()).put((Object)handlerInfo.identifier, (Object)chunk, chunkData);
    }

    public static BlockDataHandler get() {
        return instance;
    }

    static class ChunkData<T> {
        private HandlerInfo<T> handlerInfos;
        private HashMap<BlockPos, T> data = new HashMap();

        public ChunkData(HandlerInfo<T> handlerInfo) {
            this.handlerInfos = handlerInfo;
        }

        public boolean hasData() {
            return this.data.size() > 0;
        }

        public T getData(BlockPos pos) {
            return this.data.get(pos);
        }

        public void setData(BlockPos pos, T blockData) {
            if (blockData != null) {
                this.data.put(pos, blockData);
            } else {
                this.data.remove(pos);
            }
        }

        public ChunkData<T> fromBytes(ByteBuf buf) {
            while (buf.isReadable()) {
                BlockPos pos = BlockPos.fromLong((long)buf.readLong());
                ByteBuf b = buf.readBytes(buf.readInt());
                Object blockData = ((HandlerInfo)this.handlerInfos).from.apply((Object)b);
                this.data.put(pos, blockData);
            }
            return this;
        }

        public ByteBuf toBytes(ByteBuf buf) {
            for (Map.Entry<BlockPos, T> entry : this.data.entrySet()) {
                ByteBuf b = (ByteBuf)((HandlerInfo)this.handlerInfos).to.apply(entry.getValue());
                buf.writeLong(entry.getKey().toLong());
                buf.writeInt(b.writerIndex());
                buf.writeBytes(b);
            }
            return buf;
        }
    }

    static class HandlerInfo<T> {
        String identifier;
        private Function<ByteBuf, T> from;
        private Function<T, ByteBuf> to;

        public HandlerInfo(String identifier, Function<ByteBuf, T> from, Function<T, ByteBuf> to) {
            this.identifier = identifier;
            this.from = from;
            this.to = to;
        }
    }
}

