/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.util.ShaderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;

public class RenderHelper {
    private static ShaderSystem shaders;
    private static final String REPEAT_SHADER = "#version 120\nuniform sampler2D tex; uniform vec2 iconOffset; uniform vec2 iconSize;\nvoid main() {\ngl_FragColor = texture2D(tex, iconOffset + fract(gl_TexCoord[0].st) * iconSize) * gl_Color;\n}";

    public static void drawRectangleRepeated(ResourceLocation texture, int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth, int tileHeight) {
        RenderHelper.drawRectangleRepeated(x, y, z, width, height, u, v, uMax, vMax, tileWidth, tileHeight);
    }

    public static void drawRectangleRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth, int tileHeight) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", u, v);
        shaders.setUniform2f("iconSize", uMax - u, vMax - v);
        shaders.deactivate();
    }

    public static void drawRectangleXRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", u, 0.0f);
        shaders.setUniform2f("iconSize", uMax - u, 1.0f);
        shaders.deactivate();
    }

    public static void drawRectangleYRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileHeight) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", 0.0f, v);
        shaders.setUniform2f("iconSize", 1.0f, vMax - v);
        shaders.deactivate();
    }

    public static void loadShaders() {
        if (shaders == null) {
            shaders = new ShaderSystem();
            shaders.addShader(REPEAT_SHADER, 35632);
        }
    }

    public static ScaledResolution getScaledResolution() {
        return new ScaledResolution(Minecraft.getMinecraft(), Minecraft.getMinecraft().displayWidth, Minecraft.getMinecraft().displayHeight);
    }

    public static int getScaledWidth(int width) {
        return width / RenderHelper.getScaledResolution().getScaleFactor();
    }

    public static int getScaledHeight(int height) {
        return height / RenderHelper.getScaledResolution().getScaleFactor();
    }

    public static int computeGuiScale() {
        Minecraft mc = Minecraft.getMinecraft();
        int scaleFactor = 1;
        int k = mc.gameSettings.guiScale;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.displayWidth / (scaleFactor + 1) >= 320 && mc.displayHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }
}

