/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;

public class EnumFacingUtils {
    public static int getRotationCount(EnumFacing facing) {
        if (facing == null) {
            return 0;
        }
        switch (facing) {
            case EAST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static int getRotationCount(IBlockState state) {
        EnumFacing direction = DirectionalComponent.getDirection(state);
        return EnumFacingUtils.getRotationCount(direction);
    }

    public static EnumFacing rotateFacing(EnumFacing facing, int count) {
        if (facing == null) {
            return null;
        }
        while (count-- > 0) {
            facing = facing.rotateAround(EnumFacing.Axis.Y);
        }
        return facing;
    }

    public static EnumFacing getRealSide(IBlockState state, EnumFacing side) {
        if (state == null || side == null) {
            return side;
        }
        EnumFacing direction = DirectionalComponent.getDirection(state);
        if (direction == EnumFacing.SOUTH) {
            return side;
        }
        if (direction == EnumFacing.DOWN) {
            return side.rotateAround(EnumFacing.Axis.X);
        }
        if (direction == EnumFacing.UP) {
            switch (side) {
                case UP: {
                    return EnumFacing.SOUTH;
                }
                case DOWN: {
                    return EnumFacing.NORTH;
                }
                case NORTH: {
                    return EnumFacing.UP;
                }
                case SOUTH: {
                    return EnumFacing.DOWN;
                }
            }
            return side;
        }
        int count = EnumFacingUtils.getRotationCount(direction);
        side = EnumFacingUtils.rotateFacing(side, count);
        return side;
    }
}

