/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;

public class BlockPosUtils {
    public static BlockPos rotate(BlockPos pos, int rotation) {
        int[] cos = new int[]{1, 0, -1, 0};
        int[] sin = new int[]{0, 1, 0, -1};
        int a = -rotation & 3;
        int newX = pos.getX() * cos[a] - pos.getZ() * sin[a];
        int newZ = pos.getX() * sin[a] + pos.getZ() * cos[a];
        return new BlockPos(newX, pos.getY(), newZ);
    }

    public static BlockPos chunkPosition(BlockPos pos) {
        return new BlockPos(pos.getX() - (pos.getX() >> 4) * 16, pos.getY() - (pos.getY() >> 4) * 16, pos.getZ() - (pos.getZ() >> 4) * 16);
    }

    public static Iterable<BlockPos> getAllInBox(AxisAlignedBB aabb) {
        return BlockPos.getAllInBox((BlockPos)new BlockPos(aabb.minX, aabb.minY, aabb.minZ), (BlockPos)new BlockPos(Math.ceil(aabb.maxX) - 1.0, Math.ceil(aabb.maxY) - 1.0, Math.ceil(aabb.maxZ) - 1.0));
    }

    public static ByteBuf toBytes(BlockPos pos) {
        ByteBuf buf = Unpooled.buffer((int)8);
        buf.writeLong(pos.toLong());
        return buf;
    }

    public static BlockPos fromBytes(ByteBuf buf) {
        return BlockPos.fromLong((long)buf.readLong());
    }
}

